/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.earth;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityFloatingBlock;
import com.crowsofwar.avatar.entity.data.FloatingBlockBehavior;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import com.crowsofwar.gorecore.util.VectorI;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class AbilityEarthControl
extends Ability {
    private static final String BOOMERANG = "boomerang";
    private static final String BLOCK_HITS = "blockHits";
    private static final String TURN_SOLID = "turnSolid";
    private static final String EXPLOSION = "explosion";
    private final Random random = new Random();

    public AbilityEarthControl() {
        super(Earthbending.ID, "earth_control");
        this.requireRaytrace(-1.0, true);
    }

    @Override
    public void init() {
        super.init();
        this.addProperties(BLOCK_HITS, "range", "radius");
        this.addBooleanProperties(BOOMERANG, TURN_SOLID, EXPLOSION);
    }

    @Override
    public boolean isUtility() {
        return true;
    }

    @Override
    public void execute(AbilityContext ctx) {
        VectorI targetPos = ctx.getLookPosI();
        Vec3d lookPos = ctx.getBenderEntity().func_174824_e(1.0f);
        VectorI entityPos = new VectorI((int)lookPos.field_72450_a, (int)lookPos.field_72448_b, (int)lookPos.field_72449_c);
        EntityLivingBase entity = ctx.getBenderEntity();
        int range = this.getProperty("range", ctx).intValue();
        if (targetPos != null && targetPos.dist(entityPos) <= (double)range) {
            this.pickupBlock(ctx, targetPos.toBlockPos());
        } else {
            Vector pos = Earthbending.getClosestEarthbendableBlock(entity, ctx, this, 2);
            if (pos != null) {
                this.pickupBlock(ctx, pos.toBlockPos());
            }
        }
    }

    private void pickupBlock(AbilityContext ctx, BlockPos pos) {
        boolean bendable;
        World world = ctx.getWorld();
        Bender bender = ctx.getBender();
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        IBlockState ibs = world.func_180495_p(pos);
        if (!ibs.func_185913_b() && !Earthbending.isBendable(world, pos, ibs, 2)) {
            ibs = world.func_180495_p(pos.func_177977_b());
        }
        Block block = ibs.func_177230_c();
        int maxBlocks = 1;
        int heldBlocks = 0;
        if (ctx.getLevel() == 2) {
            maxBlocks = 2;
        } else if (ctx.getDynamicPath().equals((Object)AbilityData.AbilityTreePath.FIRST)) {
            maxBlocks = 3;
        }
        List blocks = world.func_72872_a(EntityFloatingBlock.class, entity.func_174813_aQ().func_72314_b(3.0, 2.0, 3.0));
        for (EntityFloatingBlock b : blocks) {
            if (b.getController() != entity) continue;
            ++heldBlocks;
        }
        if (!(bendable |= !(bendable = Earthbending.isBendable(world, pos, ibs, 2)) && !Earthbending.isBendable(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()), 2) && !(block instanceof BlockSnow) && !(block instanceof BlockTallGrass) && world.func_180495_p(pos).func_185915_l()) && Earthbending.getClosestEarthbendableBlock(entity, ctx, this, 2) != null) {
            pos = Objects.requireNonNull(Earthbending.getClosestEarthbendableBlock(entity, ctx, this, 2)).toBlockPos();
        }
        if (!(ibs = world.func_180495_p(pos)).func_185913_b() && !Earthbending.isBendable(world, pos, ibs, 2)) {
            ibs = world.func_180495_p(pos.func_177977_b());
        }
        block = ibs.func_177230_c();
        if (!world.func_175623_d(pos) && (bendable |= !(bendable = Earthbending.isBendable(world, pos, ibs, 2)) && Earthbending.isBendable(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()), 2) && !(block instanceof BlockSnow) && !(block instanceof BlockTallGrass) && world.func_180495_p(pos).func_185915_l()) && heldBlocks < maxBlocks) {
            AbilityData abilityData = ctx.getData().getAbilityData(this);
            if (bender.consumeChi(this.getChiCost(ctx) / 4.0f)) {
                EntityFloatingBlock floating = new EntityFloatingBlock(world, ibs);
                floating.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                floating.setItemDropsEnabled(!bender.isCreativeMode());
                float damageMult = this.getProperty("damage", ctx).floatValue();
                float chiOnHit = this.getProperty("chiOnHit", ctx).floatValue();
                float knockback = this.getProperty("knockback", ctx).floatValue() / 8.0f;
                damageMult = (float)((double)damageMult * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
                double dist = 2.5;
                Vector force = new Vector(0.0, Math.sqrt(20.0 * dist), 0.0);
                floating.setVelocity(force);
                floating.setBehavior(new FloatingBlockBehavior.PickUp());
                floating.setOwner(entity);
                floating.setAbility(this);
                floating.setDamageMult(damageMult);
                floating.setHitsLeft(this.getProperty(BLOCK_HITS, ctx).intValue());
                floating.setXp(this.getProperty("xpOnHit", ctx).floatValue());
                floating.setLifeTime((int)(20.0 + (double)((float)this.getProperty("lifeTime", ctx).intValue() * abilityData.getXpModifier()) * abilityData.getDamageMult()));
                floating.setChiHit(chiOnHit);
                floating.setBoomerang(this.getBooleanProperty(BOOMERANG, ctx));
                floating.setPush(knockback);
                floating.setExplosionDamage(damageMult / 4.0f);
                floating.setExplosionSize(damageMult / 6.0f);
                floating.setExplosionStrength(damageMult / 6.0f);
                floating.setTurnSolid(this.getBooleanProperty(TURN_SOLID, ctx));
                floating.setExplosion(this.getBooleanProperty(EXPLOSION, ctx));
                floating.setDamageSource("avatar_Earth_floatingBlock");
                floating.setTier(this.getCurrentTier(ctx));
                if (ConfigStats.STATS_CONFIG.preventEarthGriefing) {
                    floating.setItemDropsEnabled(false);
                } else {
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)floating);
                }
                SoundType sound = block.getSoundType(ibs, world, pos, (Entity)entity);
                world.func_184133_a(null, floating.func_180425_c(), sound.func_185845_c(), SoundCategory.PLAYERS, sound.func_185843_a(), sound.func_185847_b());
                if (!data.hasStatusControl(StatusControlController.PLACE_BLOCK)) {
                    data.addStatusControl(StatusControlController.PLACE_BLOCK);
                }
                if (!data.hasStatusControl(StatusControlController.THROW_BLOCK)) {
                    data.addStatusControl(StatusControlController.THROW_BLOCK);
                }
            }
        } else {
            world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 1.0f, (float)(this.random.nextGaussian() / 0.25 + 0.375));
        }
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean isOffensive() {
        return true;
    }

    @Override
    public int getCooldown(AbilityContext ctx) {
        return 0;
    }

    @Override
    public float getBurnOut(AbilityContext ctx) {
        return 0.0f;
    }

    @Override
    public float getExhaustion(AbilityContext ctx) {
        return 0.0f;
    }
}

