/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.earth;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.AvatarWorldData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.ScheduledDestroyBlock;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AbilityMining
extends Ability {
    private static final String MINING_DELAY = "miningDelay";
    private static final String MINE_ORES = "oreVein";
    private static final String FORTUNE = "fortune";

    public AbilityMining() {
        super(Earthbending.ID, "mine_blocks");
    }

    @Override
    public boolean isUtility() {
        return true;
    }

    @Override
    public void init() {
        super.init();
        this.addProperties("range", FORTUNE, MINING_DELAY);
        this.addBooleanProperties(MINE_ORES);
    }

    @Override
    public void execute(AbilityContext ctx) {
        Bender bender = ctx.getBender();
        if (bender.consumeChi(this.getChiCost(ctx)) && !ctx.getWorld().field_72995_K) {
            EntityLivingBase entity = ctx.getBenderEntity();
            World world = ctx.getWorld();
            AbilityData abilityData = ctx.getAbilityData();
            Vector direction = this.getDirection(entity);
            List<Vector> rays = this.getRaysStartPos(entity, direction);
            int dist = this.getDistance(ctx);
            int fortune = this.getProperty(FORTUNE, ctx).intValue();
            int breakBlockTime = this.getProperty(MINING_DELAY, ctx).intValue();
            dist = (int)((double)dist * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            fortune = (int)((double)fortune * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            breakBlockTime = (int)((float)breakBlockTime * ((2.0f - abilityData.getXpModifier()) * (1.0f / abilityData.getXpModifier())));
            LinkedList<BlockPos> oresToBeMined = new LinkedList<BlockPos>();
            HashSet<BlockPos> alreadyMinedOres = new HashSet<BlockPos>();
            block0: for (Vector ray : rays) {
                for (int i = 1; i <= dist; ++i) {
                    boolean success;
                    BlockPos pos = ray.plus(direction.times(i)).toBlockPos();
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (this.isBreakableOre(world, pos)) {
                        oresToBeMined.add(pos);
                    }
                    if (!(success = this.breakBlock(pos, ctx, (i - 1) * breakBlockTime + breakBlockTime, fortune)) && block != Blocks.field_150350_a) continue block0;
                    if (!success) continue;
                    abilityData.addXp(this.getProperty("xpOnUse", ctx).floatValue() * (0.25f / (float)dist));
                }
            }
            if (this.getBooleanProperty(MINE_ORES, ctx)) {
                this.mineNextOre(ctx, oresToBeMined, alreadyMinedOres, 0);
            }
        }
    }

    private int getDistance(AbilityContext ctx) {
        float max = this.getProperty("range", ctx).floatValue();
        float min = max * 0.5f;
        return (int)((double)min + Math.random() * (double)(max - min));
    }

    private Vector getDirection(EntityLivingBase entity) {
        Vector look = Vector.getLookRectangular((Entity)entity);
        return new Vector(Math.round(look.x()), Math.round(look.y()), Math.round(look.z()));
    }

    private List<Vector> getRaysStartPos(EntityLivingBase entity, Vector direction) {
        ArrayList<Vector> rays = new ArrayList<Vector>();
        rays.add(new Vector(entity.func_180425_c()));
        rays.add(new Vector(entity.func_180425_c().func_177984_a()));
        if (direction.x() != 0.0 && direction.z() != 0.0) {
            rays.add(new Vector(entity.func_180425_c().func_177974_f()));
            rays.add(new Vector(entity.func_180425_c().func_177974_f().func_177984_a()));
        }
        if (direction.y() != 0.0) {
            rays.add(new Vector(entity.func_180425_c().func_177981_b(2)));
        }
        return rays;
    }

    private boolean breakBlock(BlockPos pos, AbilityContext ctx, int delay, int fortune) {
        boolean bendable;
        World world = ctx.getWorld();
        Block block = world.func_180495_p(pos).func_177230_c();
        AvatarWorldData wd = AvatarWorldData.getDataFromWorld(world);
        boolean bl = bendable = Earthbending.isBendable(world, pos, world.func_180495_p(pos), 2) && block != Blocks.field_150350_a;
        if (bendable) {
            boolean drop = !ctx.getBender().isCreativeMode();
            wd.getScheduledDestroyBlocks().add(new ScheduledDestroyBlock(wd, pos, delay, drop, fortune));
            return true;
        }
        return false;
    }

    private void mineNextOre(AbilityContext ctx, Queue<BlockPos> queue, Set<BlockPos> alreadyInspected, int oresMined) {
        World world = ctx.getWorld();
        BlockPos pos = queue.poll();
        if (pos == null) {
            return;
        }
        if (this.breakBlock(pos, ctx, oresMined * 2 + 20, 3)) {
            ++oresMined;
        }
        for (int j = 0; j < 6; ++j) {
            EnumFacing facing = EnumFacing.values()[j];
            BlockPos inspectingPos = pos.func_177972_a(facing);
            if (!this.isBreakableOre(world, inspectingPos) || alreadyInspected.contains(inspectingPos)) continue;
            queue.add(inspectingPos);
            alreadyInspected.add(inspectingPos);
        }
        if (!queue.isEmpty() && oresMined < 15) {
            this.mineNextOre(ctx, queue, alreadyInspected, oresMined);
        }
    }

    private boolean isBreakableOre(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return (block instanceof BlockOre || block instanceof BlockRedstoneOre) && Earthbending.isBendable(world, pos, world.func_180495_p(pos), 2);
    }
}

