/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.earth;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.EntityRavine;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AbilityRavine
extends Ability {
    private static final String DESTRUCTION = "destruction";
    private static final String DROP_EQUIPMENT = "dropEquipment";
    private static final String WAVE = "wave";

    public AbilityRavine() {
        super(Earthbending.ID, "ravine");
    }

    @Override
    public void init() {
        super.init();
        this.addBooleanProperties(DESTRUCTION, DROP_EQUIPMENT, WAVE);
    }

    @Override
    public void execute(AbilityContext ctx) {
        Bender bender = ctx.getBender();
        EntityLivingBase entity = ctx.getBenderEntity();
        World world = ctx.getWorld();
        if (bender.consumeChi(this.getChiCost(ctx))) {
            AbilityData abilityData = ctx.getData().getAbilityData(this);
            double speed = this.getProperty("speed", ctx).floatValue() * 3.0f;
            float damage = this.getProperty("damage", ctx).floatValue();
            int lifetime = this.getProperty("lifeTime", ctx).intValue();
            float size = this.getProperty("size", ctx).floatValue() / 2.0f;
            speed *= abilityData.getDamageMult() * (double)abilityData.getXpModifier();
            damage = (float)((double)damage * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            lifetime = (int)((double)lifetime * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            size = (float)((double)size * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            int ravines = this.getBooleanProperty(WAVE, ctx) ? 3 : 1;
            for (int i = 0; i < ravines; ++i) {
                Vector pos = Vector.getEntityPos((Entity)entity);
                Vector side = Vector.getLookRectangular((Entity)entity).withY(0.0);
                Vector look = Vector.toRectangular(Math.toRadians(entity.field_70177_z), 0.0);
                if (this.getBooleanProperty(WAVE, ctx)) {
                    side = Vector.toRectangular(Math.toRadians(entity.field_70177_z - 90.0f + (float)(i * 90)), 0.0).times((double)size * 1.5).withY(0.0);
                }
                pos = pos.plus(side).plus(Vector.getLookRectangular((Entity)entity).times(0.5 * (double)size).withY(0.0));
                BlockPos targetPos = pos.toBlockPos().func_177977_b();
                BlockPos secondPos = pos.toBlockPos().func_177979_c(2);
                boolean targetBendable = Earthbending.isBendable(world, targetPos, world.func_180495_p(targetPos), 2);
                boolean secondBendable = Earthbending.isBendable(world, secondPos, world.func_180495_p(secondPos), 2);
                if (targetBendable || secondBendable) {
                    EntityRavine ravine = new EntityRavine(world);
                    ravine.setOwner(entity);
                    ravine.setDamage(damage);
                    ravine.setPosition(targetBendable ? pos : pos.minusY(1.0));
                    ravine.setVelocity(look.times(speed));
                    ravine.setAbility(this);
                    ravine.setElement(new Earthbending());
                    ravine.setLifeTime(lifetime);
                    ravine.setEntitySize(size);
                    ravine.setBehaviour(new RavineBehaviour());
                    ravine.setXp(this.getProperty("xpOnHit", ctx).floatValue());
                    ravine.setDistance(speed);
                    ravine.setBreakBlocks(this.getBooleanProperty(DESTRUCTION, ctx));
                    ravine.setDropEquipment(this.getBooleanProperty(DROP_EQUIPMENT, ctx));
                    ravine.setDamageSource("avatar_Earth_ravine");
                    if (world.field_72995_K) continue;
                    world.func_72838_d((Entity)ravine);
                    continue;
                }
                bender.sendMessage("avatar.earthSourceFail");
            }
        }
    }

    @Override
    public boolean isOffensive() {
        return true;
    }

    @Override
    public int getBaseTier() {
        return 2;
    }

    public static class RavineBehaviour
    extends OffensiveBehaviour {
        public OffensiveBehaviour onUpdate(EntityOffensive entity) {
            int frequency;
            if (entity instanceof EntityRavine && entity.field_70173_aa % (frequency = 2 - (int)Math.min(entity.velocity().magnitude() / 20.0, 1.0)) == 0) {
                ((EntityRavine)entity).spawnEntity();
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

