/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.earth;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.bending.bending.earth.powermods.RestorePowerModifier;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;

public class AbilityRestore
extends Ability {
    public AbilityRestore() {
        super(Earthbending.ID, "restore");
    }

    @Override
    public void init() {
        super.init();
        this.addProperties("radius", "strengthDuration", "strengthLevel", "slownessDuration", "slownessLevel", "resistanceDuration", "resistanceLevel", "regenDuration", "regenLevel", "saturationDuration", "saturationLevel", "chiBoost", "chiRegenBoost");
    }

    @Override
    public boolean isBuff() {
        return true;
    }

    @Override
    public void execute(AbilityContext ctx) {
        BendingData data = ctx.getData();
        AbilityData abilityData = data.getAbilityData(this);
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        if (bender.consumeChi(this.getChiCost(ctx)) && Earthbending.getClosestEarthbendableBlock(entity, ctx, this, 2) != null) {
            abilityData.addXp(this.getProperty("xpOnUse", ctx).floatValue());
            int duration = this.getProperty("duration", ctx).intValue();
            int resistanceLevel = this.getProperty("resistanceLevel", ctx).intValue();
            int slownessLevel = this.getProperty("slownessLevel", ctx).intValue();
            int regenLevel = this.getProperty("regenLevel", ctx).intValue();
            int saturationLevel = this.getProperty("saturationLevel", ctx).intValue();
            int strengthLevel = this.getProperty("strengthLevel", ctx).intValue();
            int resistanceDuration = this.getProperty("resistanceDuration", ctx).intValue();
            int slownessDuration = this.getProperty("slownessDuration", ctx).intValue();
            int regenDuration = this.getProperty("regenDuration", ctx).intValue();
            int saturationDuration = this.getProperty("saturationDuration", ctx).intValue();
            int strengthDuration = this.getProperty("strengthDuration", ctx).intValue();
            duration = (int)((double)duration * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            regenDuration = (int)((double)regenDuration * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            slownessDuration = (int)((double)slownessDuration * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            regenDuration = (int)((double)regenDuration * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            saturationDuration = (int)((double)saturationDuration * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            strengthDuration = (int)((double)strengthDuration * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            if (resistanceLevel > 0) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76429_m, resistanceDuration, resistanceLevel - 1));
            }
            if (slownessLevel > 0) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, slownessDuration, slownessLevel - 1));
            }
            if (regenLevel > 0) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, regenDuration, regenLevel - 1));
            }
            if (strengthLevel > 0) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, strengthDuration, resistanceLevel));
            }
            if (saturationLevel > 0) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76443_y, saturationDuration, saturationLevel - 1));
            }
            RestorePowerModifier modifier = new RestorePowerModifier();
            modifier.setTicks(duration);
            data.getPowerRatingManager(this.getBendingId()).addModifier(modifier, ctx);
            data.addTickHandler(TickHandlerController.RESTORE_PARTICLE_SPAWNER, ctx);
        }
    }

    @Override
    public int getBaseTier() {
        return 5;
    }

    @Override
    public int getCooldown(AbilityContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        int coolDown = 160;
        if (ctx.getLevel() == 1) {
            coolDown = 150;
        }
        if (ctx.getLevel() == 2) {
            coolDown = 140;
        }
        if (ctx.isDynamicMasterLevel(AbilityData.AbilityTreePath.FIRST)) {
            coolDown = 130;
        }
        if (ctx.isDynamicMasterLevel(AbilityData.AbilityTreePath.SECOND)) {
            coolDown = 140;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
            coolDown = 0;
        }
        return coolDown;
    }
}

