/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.earth;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityWall;
import com.crowsofwar.avatar.entity.EntityWallSegment;
import com.crowsofwar.avatar.entity.data.WallBehavior;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class AbilityWall
extends Ability {
    public static final String WALL_REACH = "wallReach";
    public static final String SIZE_MIN = "sizeMin";
    public static final String SIZE_MAX = "sizeMax";
    public static final String MULTI_WALL = "multiWall";
    public static final String SHOOT_BLOCKS = "shootBlocks";
    public static final String SHOOT_WALLS = "shootWall";

    public AbilityWall() {
        super(Earthbending.ID, "wall");
        this.requireRaytrace(20.0, false);
    }

    @Override
    public void init() {
        super.init();
        this.addProperties(WALL_REACH, SIZE_MIN, SIZE_MAX);
        this.addBooleanProperties(SHOOT_BLOCKS, MULTI_WALL, SHOOT_WALLS);
    }

    @Override
    public void execute(AbilityContext ctx) {
        Bender bender = ctx.getBender();
        if (bender.consumeChi(this.getChiCost(ctx))) {
            EntityLivingBase entity = ctx.getBenderEntity();
            World world = ctx.getWorld();
            EnumFacing cardinal = entity.func_174811_aO();
            BendingData data = ctx.getData();
            AbilityData abilityData = data.getAbilityData(this);
            int reach = Math.round(this.getProperty(WALL_REACH, ctx).floatValue());
            int whMin = this.getProperty(SIZE_MIN, ctx).intValue();
            int whMax = this.getProperty(SIZE_MAX, ctx).intValue();
            whMin = (int)((double)whMin * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            whMax = (int)((double)whMax * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            reach = (int)((double)reach * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            Random random = new Random();
            boolean wallCreated = false;
            if (this.getBooleanProperty(MULTI_WALL, ctx)) {
                BlockPos wallPos = entity.func_180425_c().func_177977_b().func_177963_a(entity.func_70040_Z().field_72450_a, 0.0, entity.func_70040_Z().field_72449_c);
                Block wallBlock = world.func_180495_p(wallPos).func_177230_c();
                if (wallBlock == Blocks.field_150350_a) {
                    for (int i = 0; i <= reach && (wallBlock = world.func_180495_p(wallPos = wallPos.func_177977_b()).func_177230_c()) == Blocks.field_150350_a; ++i) {
                    }
                }
                if (!Earthbending.isBendable(world, wallPos, world.func_180495_p(wallPos), 2)) {
                    Vector tempPos = Earthbending.getClosestEarthbendableBlock(entity, ctx, WALL_REACH, this, 2);
                    if (tempPos != null) {
                        wallPos = tempPos.toBlockPos();
                    }
                    wallBlock = world.func_180495_p(wallPos).func_177230_c();
                }
                if (wallBlock != Blocks.field_150350_a) {
                    wallCreated = this.createSurroundingWalls(ctx, world, wallPos, wallBlock, entity, whMin, whMax, random);
                }
            } else {
                wallCreated = this.createLinearWall(ctx, world, reach, cardinal, entity, whMin, whMax, whMax - 1, whMax, random);
            }
            if (wallCreated) {
                abilityData.addXp(this.getProperty("xpOnUse", ctx).floatValue());
                ctx.getData().addStatusControl(StatusControlController.DROP_WALL);
                ctx.getData().addStatusControl(StatusControlController.PLACE_WALL);
                if (this.getBooleanProperty(SHOOT_BLOCKS, ctx)) {
                    ctx.getData().addStatusControl(StatusControlController.SHOOT_WALL);
                }
                if (this.getBooleanProperty(SHOOT_WALLS, ctx)) {
                    ctx.getData().addStatusControl(StatusControlController.PUSH_WALL);
                }
            }
        }
    }

    private boolean createLinearWall(AbilityContext ctx, World world, int reach, EnumFacing cardinal, EntityLivingBase entity, int whMin, int whMax, int height, int length, Random random) {
        Block lookBlock;
        BlockPos lookPos;
        BlockPos entityPos = entity.func_180425_c().func_177977_b();
        if (ctx.isLookingAtBlock() && ctx.getLookPosI() != null) {
            lookPos = ctx.getLookPosI().toBlockPos();
            if (lookPos.func_177951_i((Vec3i)entityPos) > (double)reach) {
                lookPos = entityPos.func_177967_a(cardinal, reach);
            }
        } else {
            lookPos = entityPos.func_177967_a(cardinal, reach);
        }
        if ((lookBlock = world.func_180495_p(lookPos).func_177230_c()) instanceof BlockTallGrass) {
            lookPos = lookPos.func_177977_b();
        } else if (lookBlock instanceof BlockDoublePlant) {
            lookPos = lookPos.func_177979_c(2);
        }
        if (lookBlock == Blocks.field_150350_a) {
            for (int i = 0; i <= reach && (lookBlock = world.func_180495_p(lookPos = lookPos.func_177977_b()).func_177230_c()) == Blocks.field_150350_a; ++i) {
            }
        }
        if (Earthbending.isBendable(world, lookPos, world.func_180495_p(lookPos), 2)) {
            return this.createWall(ctx, world, lookPos.func_177967_a(cardinal.func_176746_e(), -1), lookBlock, cardinal, entity, whMin, whMax, height, length, random);
        }
        if (Earthbending.getClosestEarthbendableBlock(entity, ctx, WALL_REACH, this, 2) != null) {
            lookPos = Objects.requireNonNull(Earthbending.getClosestEarthbendableBlock(entity, ctx, WALL_REACH, this, 2)).toBlockPos();
        }
        return this.createWall(ctx, world, lookPos.func_177967_a(cardinal.func_176746_e(), -1), lookBlock, cardinal, entity, whMin, whMax, height, length, random);
    }

    private boolean createSurroundingWalls(AbilityContext ctx, World world, BlockPos lookPos, Block lookBlock, EntityLivingBase entity, int whMin, int whMax, Random random) {
        boolean wall0Created = this.createWall(ctx, world, lookPos.func_177967_a(EnumFacing.EAST, 3), lookBlock, EnumFacing.EAST, entity, whMin, whMax, whMax - 1, whMax, random);
        boolean wall1Created = this.createWall(ctx, world, lookPos.func_177967_a(EnumFacing.NORTH, 3), lookBlock, EnumFacing.NORTH, entity, whMin, whMax, whMax - 1, whMax, random);
        boolean wall2Created = this.createWall(ctx, world, lookPos.func_177967_a(EnumFacing.SOUTH, 3), lookBlock, EnumFacing.SOUTH, entity, whMin, whMax, whMax - 1, whMax, random);
        boolean wall3Created = this.createWall(ctx, world, lookPos.func_177967_a(EnumFacing.WEST, 3), lookBlock, EnumFacing.WEST, entity, whMin, whMax, whMax - 1, whMax, random);
        return wall0Created || wall1Created || wall2Created || wall3Created;
    }

    private boolean createWall(AbilityContext ctx, World world, BlockPos wallPos, Block wallBlock, EnumFacing direction, EntityLivingBase entity, int whMin, int whMax, int height, int width, Random random) {
        EntityWall wall = new EntityWall(world);
        if (Earthbending.isBendable(world, wallPos, world.func_180495_p(wallPos), 2) || ConfigStats.STATS_CONFIG.plantBendableBlocks.contains(wallBlock)) {
            wall.func_70107_b((double)wallPos.func_177958_n() + 0.5, wallPos.func_177956_o(), (double)wallPos.func_177952_p() + 0.5);
            wall.setOwner(entity);
            wall.setTier(this.getCurrentTier(ctx));
            for (int i = 0; i < width; ++i) {
                int wallHeight = AvatarUtils.getRandomNumberInRange(1, height) + (whMax - whMin);
                int horizMod = -(height / 2) + i;
                int x = wallPos.func_177958_n() + (direction == EnumFacing.NORTH || direction == EnumFacing.SOUTH ? horizMod : 0);
                int y = wallPos.func_177956_o() - (height - 1);
                int z = wallPos.func_177952_p() + (direction == EnumFacing.EAST || direction == EnumFacing.WEST ? horizMod : 0);
                EntityWallSegment seg = new EntityWallSegment(world);
                seg.attachToWall(wall);
                seg.func_70107_b((double)x + 0.5, y, (double)z + 0.5);
                seg.setDirection(direction);
                seg.setOwner(entity);
                seg.setAbility(this);
                seg.setSegmentHeight(height);
                seg.setBehavior(new WallBehavior.Rising());
                seg.setTier(this.getCurrentTier(ctx));
                boolean foundAir = false;
                boolean dontBreakMore = false;
                for (int j = seg.getSegmentHeight() - 1; j >= 0; --j) {
                    BlockPos pos = new BlockPos(x, y + j, z);
                    IBlockState state = world.func_180495_p(pos);
                    boolean bendable = Earthbending.isBendable(world, pos, state, 2);
                    if (!bendable || dontBreakMore) {
                        state = Blocks.field_150350_a.func_176223_P();
                        dontBreakMore = true;
                    }
                    if (!foundAir && state.func_177230_c() == Blocks.field_150350_a) {
                        seg.func_70105_a(seg.field_70130_N, height - j - 1);
                        seg.setBlocksOffset(-(j + 1));
                        seg.setPosition(seg.position().withY(y + j + 1));
                        foundAir = true;
                    }
                    if (foundAir && state.func_177230_c() != Blocks.field_150350_a) {
                        seg.func_70105_a(seg.field_70130_N, height - j);
                        seg.setBlocksOffset(-j);
                        seg.setPosition(seg.position().withY(y + j));
                    }
                    seg.setBlock(j, state);
                    if (bendable && !dontBreakMore && !world.field_72995_K) {
                        world.func_175698_g(pos);
                    }
                    if (j <= height - wallHeight || (double)((float)AvatarUtils.getRandomNumberInRange(1, whMax) / 10.0f * (float)height) < random.nextDouble()) {
                        dontBreakMore = true;
                    }
                    if (!(seg.field_70131_O > (float)seg.getSegmentHeight())) continue;
                    seg.func_70105_a(seg.field_70130_N, seg.getSegmentHeight());
                }
                if (world.field_72995_K) continue;
                world.func_72838_d((Entity)seg);
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)wall);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isUtility() {
        return true;
    }

    @Override
    public int getBaseTier() {
        return 3;
    }
}

