/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.earth;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.client.gui.BendingMenuInfo;
import com.crowsofwar.avatar.client.gui.MenuTheme;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import java.awt.Color;
import java.util.UUID;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class Earthbending
extends BendingStyle {
    public static final UUID ID = UUID.fromString("82ad13b5-4bbe-4eaf-8aa0-00b36b33aed0");
    private final BendingMenuInfo menu;

    public Earthbending() {
        this.registerAbilities();
        Color light = new Color(225, 225, 225);
        Color brown = new Color(79, 57, 45);
        Color gray = new Color(90, 90, 90);
        Color lightBrown = new Color(255, 235, 224);
        MenuTheme.ThemeColor background = new MenuTheme.ThemeColor(lightBrown, brown);
        MenuTheme.ThemeColor edge = new MenuTheme.ThemeColor(brown, brown);
        MenuTheme.ThemeColor icon = new MenuTheme.ThemeColor(gray, light);
        this.menu = new BendingMenuInfo(new MenuTheme(background, edge, icon, 11574143), this);
    }

    public static boolean isBendable(IBlockState state) {
        Block block = state.func_177230_c();
        if (ConfigStats.STATS_CONFIG.bendableBlocks.contains(block)) {
            return true;
        }
        return ConfigStats.STATS_CONFIG.enableAutoModCompat && block.getRegistryName() != null && !block.getRegistryName().func_110624_b().equals("minecraft") && (OreDictionary.doesOreNameExist((String)block.func_149739_a()) || block instanceof BlockOre || block instanceof BlockRedstoneOre || OreDictionary.doesOreNameExist((String)block.func_149732_F())) && !(block instanceof BlockLiquid);
    }

    public static Vector getClosestEarthbendableBlock(EntityLivingBase entity, AbilityContext ctx, Ability ability) {
        World world = entity.field_70170_p;
        Vector eye = Vector.getEyePos((Entity)entity);
        float range = ability.getProperty("radius", ctx).floatValue();
        float dist = range = (float)((double)range * (ctx.getAbilityData().getDamageMult() * (double)ctx.getAbilityData().getXpModifier()));
        Vector closestPos = null;
        int angle = 12;
        for (int i = 0; i < angle; ++i) {
            for (int j = 0; j < angle; ++j) {
                double yaw = (double)entity.field_70177_z + (double)i * 360.0 / (double)angle;
                double pitch = (double)entity.field_70125_A + (double)j * 360.0 / (double)angle;
                BiPredicate<BlockPos, IBlockState> isWater = (pos, state) -> Earthbending.isBendable(state) && state.func_177230_c() != Blocks.field_150350_a;
                Vector angleVec = Vector.toRectangular(Math.toRadians(yaw), Math.toRadians(pitch));
                Raytrace.Result result = Raytrace.predicateRaytrace(world, eye, angleVec, range, isWater);
                if (!result.hitSomething() || result.getPosPrecise() == null) continue;
                eye = eye.plus(Vector.getLookRectangular((Entity)entity));
                if (!(result.getPosPrecise().dist(eye.withY(entity.func_174813_aQ().field_72338_b - 1.0)) < (double)dist)) continue;
                dist = (float)result.getPosPrecise().dist(eye.withY(entity.func_174813_aQ().field_72338_b));
                closestPos = result.getPosPrecise();
            }
        }
        if (closestPos == null) {
            ctx.getBender().sendMessage("avatar.earthSourceFail");
        }
        return closestPos;
    }

    public static boolean isBendable(World world, BlockPos pos, IBlockState state, int maxHardness) {
        Block block = state.func_177230_c();
        if (ConfigStats.STATS_CONFIG.bendableBlocks.contains(block)) {
            return true;
        }
        return ConfigStats.STATS_CONFIG.enableAutoModCompat && state.func_185887_b(world, pos) <= (float)maxHardness && block.getRegistryName() != null && !block.getRegistryName().func_110624_b().equals("minecraft") && (OreDictionary.doesOreNameExist((String)block.func_149739_a()) || block instanceof BlockOre || block instanceof BlockRedstoneOre || OreDictionary.doesOreNameExist((String)block.func_149732_F())) && !(block instanceof BlockLiquid);
    }

    public static Vector getClosestEarthbendableBlock(EntityLivingBase entity, AbilityContext ctx, Ability ability, int maxHardness) {
        World world = entity.field_70170_p;
        Vector eye = Vector.getEyePos((Entity)entity);
        float range = ability.getProperty("radius", ctx).floatValue();
        float dist = range = (float)((double)range * (ctx.getAbilityData().getDamageMult() * (double)ctx.getAbilityData().getXpModifier()));
        Vector closestPos = null;
        int angle = 12;
        for (int i = 0; i < angle; ++i) {
            for (int j = 0; j < angle; ++j) {
                double yaw = (double)entity.field_70177_z + (double)i * 360.0 / (double)angle;
                double pitch = (double)entity.field_70125_A + (double)j * 360.0 / (double)angle;
                BiPredicate<BlockPos, IBlockState> isWater = (pos, state) -> Earthbending.isBendable(world, pos, state, maxHardness) && state.func_177230_c() != Blocks.field_150350_a;
                Vector angleVec = Vector.toRectangular(Math.toRadians(yaw), Math.toRadians(pitch));
                Raytrace.Result result = Raytrace.predicateRaytrace(world, eye, angleVec, range, isWater);
                if (!result.hitSomething() || result.getPosPrecise() == null) continue;
                eye = eye.plus(Vector.getLookRectangular((Entity)entity));
                if (!(result.getPosPrecise().dist(eye.withY(entity.func_174813_aQ().field_72338_b - 1.0)) < (double)dist)) continue;
                dist = (float)result.getPosPrecise().dist(eye.withY(entity.func_174813_aQ().field_72338_b));
                closestPos = result.getPosPrecise();
            }
        }
        if (closestPos == null) {
            ctx.getBender().sendMessage("avatar.earthSourceFail");
        }
        return closestPos;
    }

    public static Vector getClosestEarthbendableBlock(EntityLivingBase entity, AbilityContext ctx, String property, Ability ability, int maxHardness) {
        World world = entity.field_70170_p;
        Vector eye = Vector.getEyePos((Entity)entity);
        float range = ability.getProperty(property, ctx).floatValue();
        float dist = range = (float)((double)range * (ctx.getAbilityData().getDamageMult() * (double)ctx.getAbilityData().getXpModifier()));
        Vector closestPos = null;
        int angle = 12;
        for (int i = 0; i < angle; ++i) {
            for (int j = 0; j < angle; ++j) {
                double yaw = (double)entity.field_70177_z + (double)i * 360.0 / (double)angle;
                double pitch = (double)entity.field_70125_A + (double)j * 360.0 / (double)angle;
                BiPredicate<BlockPos, IBlockState> isWater = (pos, state) -> Earthbending.isBendable(world, pos, state, maxHardness) && state.func_177230_c() != Blocks.field_150350_a;
                Vector angleVec = Vector.toRectangular(Math.toRadians(yaw), Math.toRadians(pitch));
                Raytrace.Result result = Raytrace.predicateRaytrace(world, eye, angleVec, range, isWater);
                if (!result.hitSomething() || result.getPosPrecise() == null) continue;
                eye = eye.plus(Vector.getLookRectangular((Entity)entity));
                if (!(result.getPosPrecise().dist(eye.withY(entity.func_174813_aQ().field_72338_b - 1.0)) < (double)dist)) continue;
                dist = (float)result.getPosPrecise().dist(eye.withY(entity.func_174813_aQ().field_72338_b));
                closestPos = result.getPosPrecise();
            }
        }
        if (closestPos == null) {
            ctx.getBender().sendMessage("avatar.earthSourceFail");
        }
        return closestPos;
    }

    @Override
    public int getTextColour() {
        return 0x663300;
    }

    @Override
    public BendingMenuInfo getRadialMenu() {
        return this.menu;
    }

    @Override
    public String getName() {
        return "earthbending";
    }

    @Override
    public UUID getId() {
        return ID;
    }

    @Override
    public TextFormatting getTextFormattingColour() {
        return TextFormatting.DARK_GREEN;
    }

    @Override
    public SoundEvent getRadialMenuSound() {
        return SoundEvents.field_187571_bR;
    }
}

