/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.earth;

import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.util.data.AvatarWorldData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.ScheduledDestroyBlock;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EarthbendingEvents {
    private EarthbendingEvents() {
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new EarthbendingEvents());
    }

    @SubscribeEvent
    public void digSpeed(PlayerEvent.BreakSpeed e) {
        EntityPlayer player = e.getEntityPlayer();
        World world = player.field_70170_p;
        IBlockState state = e.getState();
        if (ConfigStats.STATS_CONFIG.bendableBlocks.contains(state.func_177230_c())) {
            e.setNewSpeed(e.getOriginalSpeed() * 2.0f);
        }
    }

    @SubscribeEvent
    public void worldUpdate(TickEvent.WorldTickEvent e) {
        World world = e.world;
        if (!world.field_72995_K && e.phase == TickEvent.Phase.START) {
            AvatarWorldData wd = AvatarWorldData.getDataFromWorld(world);
            Iterator<ScheduledDestroyBlock> iterator = wd.getScheduledDestroyBlocks().iterator();
            while (iterator.hasNext()) {
                ScheduledDestroyBlock sdb = iterator.next();
                sdb.decrementTicks();
                if (sdb.getTicks() > 0) continue;
                BlockPos pos = sdb.getPos();
                IBlockState blockState = world.func_180495_p(pos);
                Block block = blockState.func_177230_c();
                this.destroyBlock(world, pos, sdb.isDrop(), sdb.getFortune());
                iterator.remove();
            }
        }
    }

    @SubscribeEvent
    public void knockbackEvent(LivingKnockBackEvent event) {
        Bender b;
        if ((event.getEntityLiving() instanceof EntityPlayer || event.getEntityLiving() instanceof EntityBender) && !(event.getEntityLiving() instanceof FakePlayer) && (b = Bender.get(event.getEntityLiving())) != null && b.getData() != null && b.getData().hasBendingId(Earthbending.ID)) {
            float powerrating = (float)b.calcPowerRating(Earthbending.ID) / 100.0f;
            if (ConfigStats.STATS_CONFIG.passiveSettings.knockbackResistanceEarth) {
                event.setStrength(event.getStrength() * (0.8f - powerrating));
            }
        }
    }

    private void destroyBlock(World world, BlockPos pos, boolean dropBlock, int fortune) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.isAir(iblockstate, (IBlockAccess)world, pos)) {
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)iblockstate));
            if (dropBlock) {
                block.func_176226_b(world, pos, iblockstate, fortune);
            }
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
    }
}

