/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.earth;

import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.PowerRatingModifier;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EarthbendingJingModifier
extends PowerRatingModifier {
    private float cachedValue;
    private float cachedTime = -1.0f;

    @Override
    public double get(BendingContext ctx) {
        float currentTime = ctx.getBenderEntity().field_70173_aa;
        if (currentTime - this.cachedTime > 40.0f || this.cachedTime == -1.0f) {
            this.cachedTime = currentTime;
            this.cachedValue = this.calculateValue(ctx);
        }
        return this.cachedValue;
    }

    private float calculateValue(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        float userHealth = entity.func_110143_aJ() / entity.func_110138_aP();
        float opponentHealth = this.getNearbyHealth(ctx);
        if (opponentHealth == 0.0f) {
            return 0.0f;
        }
        if (ctx.getBender().isCreativeMode()) {
            userHealth = 1.0f;
        }
        float diff = userHealth - opponentHealth;
        return diff * 50.0f;
    }

    private float getNearbyHealth(BendingContext ctx) {
        World world = ctx.getWorld();
        EntityLivingBase entity = ctx.getBenderEntity();
        int size = 10;
        AxisAlignedBB aabb = new AxisAlignedBB(entity.field_70165_t - (double)size, entity.field_70163_u - (double)size, entity.field_70161_v - (double)size, entity.field_70165_t + (double)size, entity.field_70163_u + (double)size, entity.field_70161_v + (double)size);
        List opponents = world.func_175647_a(EntityLivingBase.class, aabb, candidate -> candidate != ctx.getBenderEntity() && (Bender.isBenderSupported(candidate) || candidate instanceof EntityMob));
        float average = 0.0f;
        for (EntityLivingBase opponent : opponents) {
            Bender bender;
            if (Bender.isBenderSupported(opponent) && (bender = Bender.get(opponent)).isCreativeMode()) continue;
            float healthPercent = opponent.func_110143_aJ() / opponent.func_110138_aP();
            average += healthPercent / (float)opponents.size();
        }
        return average;
    }
}

