/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.earth.statctrls;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.earth.AbilityEarthRedirect;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class StatCtrlEarthRedirect
extends StatusControl {
    public StatCtrlEarthRedirect() {
        super(100, AvatarControl.CONTROL_SHIFT, StatusControl.CrosshairPosition.LEFT_OF_CROSSHAIR);
    }

    @Override
    public boolean execute(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        World world = ctx.getWorld();
        BendingData data = ctx.getData();
        Bender bender = ctx.getBender();
        AbilityData abilityData = data.getAbilityData(new AbilityEarthRedirect());
        AbilityEarthRedirect redirect = (AbilityEarthRedirect)Abilities.get("earth_redirect");
        if (abilityData.getAbilityCooldown(entity) > 0) {
            return true;
        }
        if (redirect != null) {
            int cooldown = redirect.getCooldown(abilityData);
            float exhaustion = redirect.getExhaustion(abilityData);
            float burnout = redirect.getBurnOut(abilityData);
            float chiCost = redirect.getChiCost(abilityData);
            float xp = redirect.getProperty("xpOnUse", abilityData).floatValue();
            float radius = redirect.getProperty("radius", abilityData).floatValue();
            float aimAssist = redirect.getProperty("aimAssist", abilityData).floatValue();
            float range = redirect.getProperty("range", abilityData).floatValue();
            int redirectTier = redirect.getProperty("redirectTier", abilityData).intValue();
            boolean applyInhibitors = false;
            if (entity instanceof EntityBender || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                cooldown = 0;
                exhaustion = burnout = (float)0;
                chiCost = burnout;
            }
            List redirectables = world.func_72872_a(EntityOffensive.class, entity.func_174813_aQ().func_186662_g((double)radius));
            redirectables = redirectables.stream().filter(entityOffensive -> entityOffensive.canCollideWith((Entity)entity) && entityOffensive.isRedirectable() && entityOffensive.getElement() instanceof Earthbending).collect(Collectors.toList());
            ArrayList<Entity> rangedRedirectables = new ArrayList<Entity>(Raytrace.entityRaytrace(world, entity.func_174791_d().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0), entity.func_70040_Z(), (double)aimAssist, range, entity1 -> entity1 instanceof EntityOffensive && ((EntityOffensive)entity1).getElement() instanceof Earthbending && ((EntityOffensive)entity1).canCollideWith((Entity)entity)));
            if (!redirectables.isEmpty()) {
                for (EntityOffensive e : redirectables) {
                    if (e.getTier() > redirectTier || !bender.consumeChi(chiCost)) continue;
                    e.setOwner(entity);
                    e.setBehaviour(new OffensiveBehaviour.Redirect());
                    abilityData.addXp(xp);
                    applyInhibitors = true;
                }
            } else if (!rangedRedirectables.isEmpty()) {
                for (Entity e : rangedRedirectables) {
                    if (!(e instanceof EntityOffensive) || ((EntityOffensive)e).getTier() > redirectTier || !bender.consumeChi(chiCost)) continue;
                    ((EntityOffensive)e).setOwner(entity);
                    ((EntityOffensive)e).setBehaviour(new OffensiveBehaviour.Redirect());
                    abilityData.addXp(xp);
                    applyInhibitors = true;
                }
            }
            if (applyInhibitors) {
                abilityData.setAbilityCooldown(cooldown);
                abilityData.addBurnout(burnout);
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_71020_j(exhaustion);
                }
            }
        }
        return true;
    }
}

