/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.earth.statctrls;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.earth.AbilityEarthControl;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityFloatingBlock;
import com.crowsofwar.avatar.entity.data.FloatingBlockBehavior;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class StatCtrlPlaceBlock
extends StatusControl {
    public StatCtrlPlaceBlock() {
        super(1, AvatarControl.CONTROL_RIGHT_CLICK_DOWN, StatusControl.CrosshairPosition.RIGHT_OF_CROSSHAIR);
        this.requireRaytrace(-1, true);
    }

    @Override
    public boolean execute(BendingContext ctx) {
        World world = ctx.getWorld();
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        Bender bender = ctx.getBender();
        AbilityData abilityData = AbilityData.get(entity, "earth_control");
        AbilityEarthControl control = (AbilityEarthControl)Abilities.get("earth_control");
        EntityFloatingBlock floating = AvatarEntity.lookupEntity(ctx.getWorld(), EntityFloatingBlock.class, fb -> fb.getBehavior() instanceof FloatingBlockBehavior.PlayerControlled && fb.getOwner() == ctx.getBenderEntity());
        List blocks = world.func_72872_a(EntityFloatingBlock.class, entity.func_174813_aQ().func_72314_b(3.5, 3.0, 3.5));
        if (abilityData != null && control != null && abilityData.getAbilityCooldown(entity) <= 0) {
            float chiCost = control.getChiCost(abilityData);
            float exhaustion = control.getExhaustion(abilityData);
            float burnout = control.getBurnOut(abilityData);
            int cooldown = control.getCooldown(abilityData);
            chiCost = (float)((double)chiCost * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            exhaustion = (float)((double)exhaustion * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            burnout = (float)((double)burnout * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            cooldown = (int)((double)cooldown * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                cooldown = 0;
                exhaustion = burnout = (float)0;
                chiCost = burnout;
            }
            if (floating != null && !world.field_72995_K) {
                Vec3d start = entity.func_174824_e(1.0f);
                Vec3d end = start.func_178787_e(entity.func_70040_Z().func_186678_a(5.0));
                RayTraceResult result = Raytrace.rayTrace(entity, 5.0, 1.0f);
                if (result != null) {
                    BlockPos pos = result.func_178782_a();
                    IBlockState state = world.func_180495_p(pos);
                    IBlockState upState = world.func_180495_p(pos.func_177984_a());
                    Block block = state.func_177230_c();
                    Block upBlock = upState.func_177230_c();
                    if (!(upBlock instanceof BlockBush || upBlock instanceof BlockSnow || block instanceof BlockAir)) {
                        pos = pos.func_177984_a();
                    }
                    if (block instanceof BlockSnow || block instanceof BlockBush) {
                        pos = pos.func_177977_b();
                    }
                    Vector force = new Vector(pos).minus(floating.velocity()).normalize();
                    if (bender.consumeChi(chiCost)) {
                        abilityData.addXp(control.getProperty("xpOnUse", abilityData).floatValue());
                        abilityData.addBurnout(burnout);
                        abilityData.setAbilityCooldown(cooldown);
                        if (entity instanceof EntityPlayer) {
                            ((EntityPlayer)entity).func_71020_j(exhaustion);
                        }
                        if ((blocks = blocks.stream().filter(floatingBlock -> floating.getBehavior() instanceof FloatingBlockBehavior.PlayerControlled).collect(Collectors.toList())).isEmpty()) {
                            abilityData.setRegenBurnout(true);
                        }
                        floating.setBehavior(new FloatingBlockBehavior.Place(pos));
                        floating.addVelocity(force);
                        SoundType sound = floating.getBlock().func_185467_w();
                        floating.field_70170_p.func_184133_a(null, floating.func_180425_c(), sound.func_185841_e(), SoundCategory.PLAYERS, sound.func_185843_a(), sound.func_185847_b());
                        data.removeStatusControl(StatusControlController.THROW_BLOCK);
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }
}

