/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.earth.statctrls;

import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityWallSegment;
import com.crowsofwar.avatar.entity.data.WallBehavior;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class StatCtrlPlaceWall
extends StatusControl {
    public StatCtrlPlaceWall() {
        super(21, AvatarControl.CONTROL_RIGHT_CLICK, StatusControl.CrosshairPosition.RIGHT_OF_CROSSHAIR);
    }

    @Override
    public boolean execute(BendingContext ctx) {
        World world = ctx.getWorld();
        EntityLivingBase entity = ctx.getBenderEntity();
        AbilityData abilityData = ctx.getData().getAbilityData("wall");
        EntityWallSegment wallSegment = AvatarEntity.lookupOwnedEntity(world, EntityWallSegment.class, entity);
        if (wallSegment != null && wallSegment.getBehavior() != null && wallSegment.getBehavior() instanceof WallBehavior.Waiting && abilityData.getAbilityCooldown(entity) <= 0) {
            List segments = world.func_175644_a(EntityWallSegment.class, segment -> segment.getOwner() == entity);
            for (EntityWallSegment segment2 : segments) {
                if (!segment2.getBehavior().getClass().equals(WallBehavior.Waiting.class)) continue;
                segment2.setBehavior(new WallBehavior.Place());
            }
            ctx.getData().removeStatusControl(StatusControlController.DROP_WALL);
            ctx.getData().removeStatusControl(StatusControlController.SHOOT_WALL);
            ctx.getData().removeStatusControl(StatusControlController.PUSH_WALL);
            ctx.getData().removeStatusControl(StatusControlController.PULL_WALL);
            return true;
        }
        return false;
    }
}

