/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.earth.statctrls;

import akka.japi.Pair;
import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.earth.AbilityWall;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityFloatingBlock;
import com.crowsofwar.avatar.entity.EntityWall;
import com.crowsofwar.avatar.entity.EntityWallSegment;
import com.crowsofwar.avatar.entity.data.FloatingBlockBehavior;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class StatCtrlShootWall
extends StatusControl {
    public StatCtrlShootWall() {
        super(22, AvatarControl.CONTROL_LEFT_CLICK_DOWN, StatusControl.CrosshairPosition.LEFT_OF_CROSSHAIR);
    }

    @Override
    public boolean execute(BendingContext ctx) {
        World world = ctx.getWorld();
        EntityLivingBase entity = ctx.getBenderEntity();
        Vector start = new Vector(entity.func_174791_d());
        Vector direction = new Vector(entity.func_70040_Z());
        AbilityWall ability = (AbilityWall)Abilities.get("wall");
        AbilityData abilityData = AbilityData.get(entity, "wall");
        if (ability != null && abilityData != null && abilityData.getAbilityCooldown(entity) <= 0) {
            Vector stopAt;
            double range = ability.getProperty("wallReach", abilityData).doubleValue() * abilityData.getDamageMult() * (double)abilityData.getXpModifier();
            Raytrace.Result raytrace = Raytrace.raytrace(world, start, direction, range, true);
            if (raytrace.hitSomething() && (stopAt = raytrace.getPosPrecise()) != null) {
                range = start.minus(stopAt).magnitude();
            }
            List<Entity> result = Raytrace.entityRaytrace(world, start.toMinecraft(), entity.func_70040_Z(), range, 4.0f, entity1 -> (entity1 instanceof EntityWall || entity1 instanceof EntityWallSegment) && ((AvatarEntity)((Object)entity1)).getOwner() == entity);
            EntityWall controlledWall = AvatarEntity.lookupControlledEntity(world, EntityWall.class, entity);
            EntityWallSegment segment = null;
            if (controlledWall != null) {
                int width = ability.getProperty("sizeMax", abilityData).intValue();
                width = (int)((double)width * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
                int n = AvatarUtils.getRandomNumberInRange(0, width - 1);
                segment = controlledWall.getSegment(n);
            } else if (!result.isEmpty()) {
                for (Entity w : result) {
                    EntityWall wall;
                    int width = ability.getProperty("sizeMax", abilityData).intValue();
                    width = (int)((double)width * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
                    int n = AvatarUtils.getRandomNumberInRange(0, width - 1);
                    if (w instanceof EntityWallSegment) {
                        wall = ((EntityWallSegment)w).getWall();
                        segment = wall.getSegment(n);
                        continue;
                    }
                    if (!(w instanceof EntityWall)) continue;
                    wall = (EntityWall)w;
                    segment = wall.getSegment(n);
                }
            } else {
                return false;
            }
            if (segment == null) {
                return false;
            }
            float yaw = (float)Math.toRadians(entity.field_70177_z);
            float pitch = (float)Math.toRadians(entity.field_70125_A);
            Vector lookDir = Vector.toRectangular(yaw, pitch);
            Pair<Block, Integer> toUseBlockData = this.getBlockToUseFromSegment(segment);
            Block block = (Block)toUseBlockData.first();
            int usedNum = (Integer)toUseBlockData.second();
            if (block == Blocks.field_150350_a) {
                return false;
            }
            EntityFloatingBlock floating = new EntityFloatingBlock(world);
            floating.setBlock(block);
            floating.setVelocity(lookDir.times(30.0));
            floating.setBehavior(new FloatingBlockBehavior.Thrown());
            floating.setAbility(ability);
            floating.setHitsLeft(1);
            floating.setTurnSolid(true);
            floating.setDamageSource("avatar_Earth_floatingBlock");
            floating.setBoomerang(false);
            floating.setChiHit(ability.getChiCost(abilityData) / 2.0f);
            floating.setTier(ability.getCurrentTier(abilityData));
            floating.setDamage((float)((double)(Objects.requireNonNull(Abilities.get("earth_control")).getProperty("damage", abilityData).floatValue() * abilityData.getXpModifier()) * abilityData.getDamageMult()));
            floating.setOwner(entity);
            floating.func_184224_h(true);
            floating.setPosition(segment.func_174791_d().func_72441_c(0.0, (double)(-usedNum), 0.0).func_178787_e(entity.func_70040_Z()));
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)floating);
            }
            ctx.getData().chi().consumeChi(ability.getChiCost(abilityData) / 5.0f);
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_71020_j(ability.getExhaustion(abilityData) / 5.0f);
            }
            abilityData.addBurnout(ability.getBurnOut(abilityData) / 10.0f);
        }
        return false;
    }

    private Pair<Block, Integer> getBlockToUseFromSegment(EntityWallSegment seg) {
        for (int i = seg.getSegmentHeight() - 1; i >= 0; --i) {
            Block temp = seg.getBlock(i).func_177230_c();
            if (temp == Blocks.field_150350_a) continue;
            seg.setBlock(i, Blocks.field_150350_a.func_176223_P());
            return new Pair((Object)temp, (Object)i);
        }
        return new Pair((Object)Blocks.field_150350_a, (Object)0);
    }
}

