/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.earth.statctrls;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.earth.AbilityEarthControl;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityFloatingBlock;
import com.crowsofwar.avatar.entity.data.FloatingBlockBehavior;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class StatCtrlThrowBlock
extends StatusControl {
    public StatCtrlThrowBlock() {
        super(2, AvatarControl.CONTROL_LEFT_CLICK_DOWN, StatusControl.CrosshairPosition.LEFT_OF_CROSSHAIR);
    }

    @Override
    public boolean execute(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        World world = entity.field_70170_p;
        BendingData data = ctx.getData();
        Bender bender = ctx.getBender();
        AbilityData abilityData = AbilityData.get(entity, "earth_control");
        AbilityEarthControl control = (AbilityEarthControl)Abilities.get("earth_control");
        EntityFloatingBlock floating = AvatarEntity.lookupControlledEntity(world, EntityFloatingBlock.class, entity);
        List blocks = world.func_72872_a(EntityFloatingBlock.class, entity.func_174813_aQ().func_72314_b(3.5, 3.0, 3.5));
        if (floating != null && abilityData != null && control != null && abilityData.getAbilityCooldown(entity) <= 0) {
            Vector direction;
            float yaw = (float)Math.toRadians(entity.field_70177_z);
            float pitch = (float)Math.toRadians(entity.field_70125_A);
            float forceMult = control.getProperty("speed", abilityData).floatValue() * 4.0f;
            float chiCost = control.getChiCost(abilityData);
            float exhaustion = control.getExhaustion(abilityData);
            float burnout = control.getBurnOut(abilityData);
            int cooldown = control.getCooldown(abilityData);
            chiCost = (float)((double)chiCost * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            exhaustion = (float)((double)exhaustion * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            burnout = (float)((double)burnout * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            cooldown = (int)((double)cooldown * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            forceMult = (float)((double)forceMult * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                cooldown = 0;
                exhaustion = burnout = (float)0;
                chiCost = burnout;
            }
            Vec3d look = entity.func_70040_Z();
            Vec3d pos = entity.func_174824_e(1.0f);
            RayTraceResult r = Raytrace.rayTrace(world, pos, look.func_186678_a(75.0).func_178787_e(pos), 0.0f, false, true, false, Entity.class, e -> e instanceof EntityFloatingBlock || e == entity);
            if (r != null && r.field_72307_f != null) {
                Vec3d dir = r.field_72307_f.func_178788_d(floating.func_174791_d()).func_72432_b();
                direction = new Vector(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
            } else {
                direction = Vector.toRectangular(yaw, pitch);
            }
            if (bender.consumeChi(chiCost)) {
                abilityData.setAbilityCooldown(cooldown);
                abilityData.addBurnout(burnout);
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_71020_j(exhaustion);
                }
                floating.setVelocity(direction.times(forceMult));
                floating.setBehavior(new FloatingBlockBehavior.Thrown());
            }
            data.removeStatusControl(StatusControlController.PLACE_BLOCK);
            blocks = blocks.stream().filter(block -> block.getBehavior() instanceof FloatingBlockBehavior.PlayerControlled).collect(Collectors.toList());
            if (blocks.isEmpty()) {
                abilityData.setRegenBurnout(true);
            }
            return true;
        }
        return false;
    }
}

