/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.earth.tickhandlers;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.SourceInfo;
import com.crowsofwar.avatar.bending.bending.earth.AbilityEarthspikes;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.entity.EntityEarthspike;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.EntityRavine;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.TickHandler;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import com.crowsofwar.gorecore.util.VectorI;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EarthSpikeHandler
extends TickHandler {
    private static final String EARTHSPIKE_MOVEMENT_MOD = "d241bdc5-1c7f-4b7a-b634-91a3710c5e2f";

    public EarthSpikeHandler(int id) {
        super(id);
    }

    public static void spawnEarthspike(AbilityEarthspikes ability, EntityLivingBase owner, EntityRavine spawner) {
        AbilityData abilityData = AbilityData.get(owner, ability.getName());
        World world = owner.field_70170_p;
        if (abilityData != null) {
            float chiHit = ability.getProperty("chiOnHit", abilityData).floatValue();
            float size = ability.getProperty("size", abilityData).floatValue() * 1.5f;
            float damage = ability.getProperty("damage", abilityData).floatValue();
            float maxDamage = ability.getProperty("maxDamage", abilityData).floatValue();
            float maxSize = ability.getProperty("maxSize", abilityData).floatValue() * 1.5f;
            float knockback = ability.getProperty("knockback", abilityData).floatValue() / 4.0f;
            int tier = ability.getCurrentTier(abilityData);
            float xp = ability.getProperty("xpOnHit", abilityData).floatValue();
            chiHit = ability.powerModify(chiHit, abilityData);
            size = ability.powerModify(size, abilityData);
            damage = ability.powerModify(damage, abilityData);
            maxDamage = ability.powerModify(maxDamage, abilityData);
            maxSize = ability.powerModify(maxSize, abilityData);
            knockback = ability.powerModify(knockback, abilityData);
            float chargeMult = (float)Math.min(Math.max((double)spawner.field_70173_aa / (double)spawner.getLifeTime(), 0.25), 0.75);
            damage = (float)((double)damage * (0.75 + (double)((chargeMult *= world.field_73012_v.nextFloat() * 2.0f) / 2.0f)));
            size = (float)((double)size * (0.75 + (double)(chargeMult / 2.0f)));
            chiHit = (float)((double)chiHit * (0.75 + (double)(chargeMult / 2.0f)));
            damage = Math.min(damage, maxDamage);
            size = Math.min(size, maxSize);
            BlockPos pos = spawner.func_180425_c().func_177977_b();
            IBlockState state = world.func_180495_p(pos);
            Vector realPos = spawner.position();
            if (Earthbending.isBendable(world, pos, state, 2)) {
                EntityEarthspike earthspike = new EntityEarthspike(world);
                earthspike.setOwner(owner);
                earthspike.setTier(tier);
                earthspike.setMaxEntitySize(size, size / 1.5f);
                earthspike.setEntitySize(0.05f, 0.05f);
                earthspike.setChiHit(chiHit);
                earthspike.setDamage(damage);
                earthspike.setPosition(pos.func_177984_a());
                earthspike.setTier(tier);
                earthspike.setVelocity(Vec3d.field_186680_a);
                earthspike.setLifeTime((int)(size * 30.0f));
                earthspike.setAbility(ability);
                earthspike.setPush(knockback);
                earthspike.setDamageSource("avatar_Earth_earthSpike");
                earthspike.setXp(xp);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)earthspike);
                } else {
                    for (int i = 0; i < (int)(size * 30.0f); ++i) {
                        world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, realPos.x(), realPos.y() + (double)((float)i / (size * 30.0f)), realPos.z(), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
                    }
                }
            }
        }
    }

    @Override
    public boolean tick(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        World world = ctx.getWorld();
        BendingData data = ctx.getData();
        AbilityData abilityData = data.getAbilityData("earth_spikes");
        AbilityEarthspikes ability = (AbilityEarthspikes)Abilities.get("earth_spikes");
        if (ability != null) {
            VectorI targetPos = ctx.getLookPosI();
            Vec3d lookPos = ctx.getBenderEntity().func_174824_e(1.0f);
            VectorI entityPos = new VectorI((int)lookPos.field_72450_a, (int)lookPos.field_72448_b, (int)lookPos.field_72449_c);
            int range = ability.getProperty("range", abilityData).intValue();
            range = (int)ability.powerModify(range, abilityData);
            Raytrace.Result raytrace = Raytrace.raytrace(world, Vector.getEyePos((Entity)entity).toMinecraft(), entity.func_70040_Z(), (double)range, false);
            AbilityContext context = new AbilityContext(data, entity, ctx.getBender(), raytrace, ability, abilityData.getPowerRating(), false);
            if (raytrace.hitSomething()) {
                targetPos = raytrace.getPos();
            }
            if (targetPos != null && targetPos.dist(entityPos) <= (double)range) {
                abilityData.getSourceInfo().setBlockPos(targetPos.toBlockPos());
                abilityData.setSourceInfo(this.findBlock(ability, context, targetPos.toBlockPos(), abilityData.getSourceTime()));
            } else {
                Vector pos = Earthbending.getClosestEarthbendableBlock(entity, context, ability, 2);
                if (pos != null) {
                    abilityData.getSourceInfo().setBlockPos(pos.toBlockPos());
                    abilityData.setSourceInfo(this.findBlock(ability, context, pos.toBlockPos(), abilityData.getSourceTime()));
                }
            }
            if (Earthbending.isBendable(abilityData.getSourceBlock())) {
                abilityData.incrementSourceTime();
            } else {
                abilityData.setSourceTime(0);
            }
        }
        return !data.hasStatusControl(StatusControlController.RELEASE_EARTH_SPIKE);
    }

    @Override
    public void onRemoved(BendingContext ctx) {
        super.onRemoved(ctx);
        World world = ctx.getWorld();
        Bender bender = ctx.getBender();
        EntityLivingBase entity = ctx.getBenderEntity();
        AbilityEarthspikes ability = (AbilityEarthspikes)Abilities.get("earth_spikes");
        AbilityData abilityData = AbilityData.get(entity, "earth_spikes");
        if (ability != null && abilityData != null) {
            int chargeTime = ability.getProperty("chargeTime", abilityData).intValue();
            int cooldown = ability.getCooldown(abilityData);
            float chiCost = ability.getChiCost(abilityData);
            float exhaustion = ability.getExhaustion(abilityData);
            float burnout = ability.getBurnOut(abilityData);
            float chiHit = ability.getProperty("chiOnHit", abilityData).floatValue();
            float size = ability.getProperty("size", abilityData).floatValue() * 1.5f;
            float damage = ability.getProperty("damage", abilityData).floatValue();
            float maxDamage = ability.getProperty("maxDamage", abilityData).floatValue();
            float maxSize = ability.getProperty("maxSize", abilityData).floatValue() * 1.5f;
            float knockback = ability.getProperty("knockback", abilityData).floatValue() / 4.0f;
            float radius = ability.getProperty("radius", abilityData).floatValue();
            int tier = ability.getCurrentTier(abilityData);
            float xp = ability.getProperty("xpOnHit", abilityData).floatValue();
            chiHit = ability.powerModify(chiHit, abilityData);
            size = ability.powerModify(size, abilityData);
            damage = ability.powerModify(damage, abilityData);
            maxDamage = ability.powerModify(maxDamage, abilityData);
            maxSize = ability.powerModify(maxSize, abilityData);
            chargeTime = (int)ability.powerModify(chargeTime, abilityData);
            knockback = ability.powerModify(knockback, abilityData);
            radius = ability.powerModify(radius, abilityData);
            int chargedTime = Math.min(abilityData.getSourceTime(), chargeTime);
            float chargeMult = (float)chargedTime / (float)chargeTime;
            if (bender.isCreativeMode()) {
                cooldown = 0;
                chiCost = exhaustion = (float)0;
                burnout = exhaustion;
            } else if (entity instanceof EntityBender) {
                chiCost = 0.0f;
            }
            if (abilityData.getAbilityCooldown(entity) <= 0 && chargeMult > 0.0f && bender.consumeChi(chiCost)) {
                if (Earthbending.isBendable(abilityData.getSourceBlock())) {
                    damage = (float)((double)damage * (1.0 + (double)(chargeMult / 2.0f)));
                    size = (float)((double)size * (0.75 + (double)(chargeMult / 2.0f)));
                    chiHit = (float)((double)chiHit * (1.0 + (double)(chargeMult / 2.0f)));
                    damage = Math.min(damage, maxDamage);
                    size = Math.min(size, maxSize);
                    BlockPos pos = abilityData.getSourceInfo().getBlockPos();
                    IBlockState state = abilityData.getSourceBlock();
                    int range = ability.getProperty("range", abilityData).intValue();
                    range = (int)ability.powerModify(range, abilityData);
                    Raytrace.Result raytrace = Raytrace.raytrace(world, Vector.getEyePos((Entity)entity).toMinecraft(), entity.func_70040_Z(), (double)range, false);
                    Vector realPos = Vector.ZERO;
                    realPos = raytrace.hitSomething() && raytrace.getPosPrecise() != null ? raytrace.getPosPrecise() : realPos.plus(pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, pos.func_177952_p());
                    if (Earthbending.isBendable(world, realPos.toBlockPos().func_177977_b(), state, 2)) {
                        if (ability.getBooleanProperty("spreadCircular", abilityData)) {
                            for (int a = 0; a < 8; ++a) {
                                double angle = Math.toRadians(a * 45);
                                double x = Math.sin(angle);
                                double z = Math.cos(angle);
                                if (!Earthbending.isBendable(world, realPos.plus(x *= (double)radius, -1.0, z *= (double)radius).toBlockPos(), world.func_180495_p(realPos.plus(x, -1.0, z).toBlockPos()), 2)) continue;
                                EntityEarthspike earthspike = new EntityEarthspike(world);
                                earthspike.setOwner(entity);
                                earthspike.setTier(tier);
                                earthspike.setMaxEntitySize(size, size / 1.5f);
                                earthspike.setEntitySize(0.05f, 0.05f);
                                earthspike.setChiHit(chiHit);
                                earthspike.setDamage(damage);
                                earthspike.setPosition(realPos.plus(x, 0.0, z));
                                earthspike.setTier(tier);
                                earthspike.setVelocity(Vec3d.field_186680_a);
                                earthspike.setLifeTime((int)(size * 30.0f));
                                earthspike.setAbility(ability);
                                earthspike.setPush(knockback);
                                earthspike.setDamageSource("avatar_Earth_earthSpike");
                                earthspike.setXp(xp);
                                if (!world.field_72995_K) {
                                    world.func_72838_d((Entity)earthspike);
                                    continue;
                                }
                                for (int i = 0; i < (int)(size * 30.0f); ++i) {
                                    world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, realPos.x(), realPos.y() + (double)((float)i / (size * 30.0f)), realPos.z(), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)world.func_180495_p(realPos.toBlockPos().func_177977_b()))});
                                }
                            }
                        } else {
                            EntityEarthspike earthspike = new EntityEarthspike(world);
                            earthspike.setOwner(entity);
                            earthspike.setTier(tier);
                            earthspike.setMaxEntitySize(size, size / 1.5f);
                            earthspike.setEntitySize(0.05f, 0.05f);
                            earthspike.setChiHit(chiHit);
                            earthspike.setDamage(damage);
                            earthspike.setPosition(realPos);
                            earthspike.setTier(tier);
                            earthspike.setVelocity(Vec3d.field_186680_a);
                            earthspike.setLifeTime((int)(size * 30.0f));
                            earthspike.setAbility(ability);
                            earthspike.setPush(knockback);
                            earthspike.setDamageSource("avatar_Earth_earthSpike");
                            earthspike.setXp(xp);
                            if (!world.field_72995_K) {
                                world.func_72838_d((Entity)earthspike);
                            } else {
                                for (int i = 0; i < (int)(size * 30.0f); ++i) {
                                    world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, realPos.x(), realPos.y() + (double)((float)i / (size * 30.0f)), realPos.z(), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
                                }
                            }
                        }
                        if (ability.getBooleanProperty("traceSpikes", abilityData)) {
                            EntityRavine spawner = new EntityRavine(world);
                            spawner.setOwner(entity);
                            spawner.setPosition(AvatarEntityUtils.getBottomMiddleOfEntity((Entity)entity));
                            spawner.setTier(tier);
                            spawner.setEntitySize(0.01f);
                            spawner.setPush(0.0f);
                            spawner.setDamage(0.0f);
                            spawner.setAbility(ability);
                            spawner.setVelocity(entity.func_70040_Z().func_186678_a((double)((float)range / 20.0f)));
                            spawner.setLifeTime(range * 5);
                            spawner.setDistance(range);
                            spawner.setDamageSource("avatar_Earth_earthSpike");
                            spawner.setBehaviour(new EarthspikeRavineBehaviour());
                            spawner.setElement(new Earthbending());
                            if (!world.field_72995_K) {
                                world.func_72838_d((Entity)spawner);
                            }
                        }
                    } else {
                        bender.sendMessage("avatar.earthSourceFail");
                    }
                    abilityData.setAbilityCooldown(cooldown);
                    if (entity instanceof EntityPlayer) {
                        ((EntityPlayer)entity).func_71020_j(exhaustion);
                    }
                    abilityData.addBurnout(burnout);
                }
                abilityData.clearSourceTime();
                abilityData.clearSourceBlock();
            }
        }
    }

    public void addModifier(EntityLivingBase entity, float mult) {
        AttributeModifier speedMod = new AttributeModifier(EARTHSPIKE_MOVEMENT_MOD, (double)(mult - 1.0f), 1);
    }

    public void removeModifier(EntityLivingBase entity) {
        AttributeModifier speedMod = entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(UUID.fromString(EARTHSPIKE_MOVEMENT_MOD));
        if (speedMod != null && entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(speedMod)) {
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(speedMod);
        }
    }

    private SourceInfo findBlock(AbilityEarthspikes ability, AbilityContext ctx, BlockPos pos, int time) {
        boolean bendable;
        SourceInfo sourceInfo = new SourceInfo();
        World world = ctx.getWorld();
        EntityLivingBase entity = ctx.getBenderEntity();
        IBlockState ibs = world.func_180495_p(pos);
        if (!ibs.func_185913_b() && !Earthbending.isBendable(ibs)) {
            ibs = world.func_180495_p(pos.func_177977_b());
        }
        Block block = ibs.func_177230_c();
        if (!(bendable |= !(bendable = Earthbending.isBendable(ibs)) && !Earthbending.isBendable(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()), 2) && !(block instanceof BlockSnow) && !(block instanceof BlockTallGrass) && world.func_180495_p(pos).func_185915_l()) && Earthbending.getClosestEarthbendableBlock(entity, ctx, ability, 2) != null) {
            pos = Objects.requireNonNull(Earthbending.getClosestEarthbendableBlock(entity, ctx, ability, 2)).toBlockPos();
        }
        if (!(ibs = world.func_180495_p(pos)).func_185913_b() && !Earthbending.isBendable(world, pos, ibs, 2)) {
            ibs = world.func_180495_p(pos.func_177977_b());
        }
        block = ibs.func_177230_c();
        if (!world.func_175623_d(pos) && (bendable |= !(bendable = Earthbending.isBendable(world, pos, ibs, 2)) && !Earthbending.isBendable(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()), 2) && !(block instanceof BlockSnow) && !(block instanceof BlockTallGrass) && world.func_180495_p(pos).func_185915_l())) {
            sourceInfo.setState(ibs);
            sourceInfo.setBlockPos(pos);
            sourceInfo.setWorld(world);
            sourceInfo.setTime(time);
        } else {
            world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 1.0f, (float)(world.field_73012_v.nextGaussian() / 0.25 + 0.375));
        }
        return sourceInfo;
    }

    public static class EarthspikeRavineBehaviour
    extends OffensiveBehaviour {
        public OffensiveBehaviour onUpdate(EntityOffensive entity) {
            if (entity instanceof EntityRavine) {
                EntityRavine ravine = (EntityRavine)entity;
                int frequency = 5 - (int)Math.min(entity.velocity().magnitude() / 20.0, 3.0);
                if (ravine.field_70173_aa % frequency == 0 && ravine.getAbility() instanceof AbilityEarthspikes) {
                    AbilityEarthspikes spikes = (AbilityEarthspikes)Abilities.get("earth_spikes");
                    assert (spikes != null);
                    EarthSpikeHandler.spawnEarthspike(spikes, ravine.getOwner(), ravine);
                }
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

