/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingAi;
import com.crowsofwar.avatar.bending.bending.fire.AiFireShot;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.blocks.BlockTemp;
import com.crowsofwar.avatar.blocks.BlockUtils;
import com.crowsofwar.avatar.client.particle.AvatarParticles;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.EntityFlames;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.EntityShockwave;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AbilityFireShot
extends Ability {
    public static final String SHOCKWAVE = "shockwave";
    public static final String REFLECT = "reflect";
    public static final String TRAILING_FIRE = "trailingFire";

    public AbilityFireShot() {
        super(Firebending.ID, "fire_shot");
        this.requireRaytrace(-1.0, false);
    }

    @Override
    public void init() {
        super.init();
        this.addProperties("fireR", "fireG", "fireB", "fadeR", "fadeG", "fadeB", "effectRadius");
        this.addBooleanProperties("setsFires", "smelts", SHOCKWAVE, REFLECT, TRAILING_FIRE);
    }

    @Override
    public void execute(AbilityContext ctx) {
        World world = ctx.getWorld();
        Bender bender = ctx.getBender();
        EntityLivingBase entity = ctx.getBenderEntity();
        AbilityData abilityData = ctx.getAbilityData();
        Vector pos = Vector.getEyePos((Entity)entity);
        float speed = this.getProperty("speed", ctx).floatValue() * 2.0f;
        float knockback = this.getProperty("knockback", ctx).floatValue() / 10.0f;
        float size = this.getProperty("size", ctx).floatValue();
        float damage = this.getProperty("damage", ctx).floatValue();
        float chi = this.getChiCost(ctx);
        float chiHit = this.getProperty("chiOnHit", ctx).floatValue();
        float xp = this.getProperty("xpOnHit", ctx).floatValue();
        int fireTime = this.getProperty("fireTime", ctx).intValue();
        int lifeTime = this.getProperty("lifeTime", ctx).intValue();
        int performance = this.getProperty("performanceAmount", ctx).intValue();
        double damageMult = abilityData.getDamageMult();
        damage = (float)((double)damage * ((double)abilityData.getXpModifier() * damageMult));
        size = (float)((double)size * ((double)abilityData.getXpModifier() * damageMult));
        speed = (float)((double)speed * ((double)abilityData.getXpModifier() * damageMult));
        knockback = (float)((double)knockback * ((double)abilityData.getXpModifier() * damageMult));
        fireTime = (int)((double)fireTime * Math.min((double)abilityData.getXpModifier() * damageMult, 0.25));
        lifeTime = (int)((double)lifeTime * Math.min((double)abilityData.getXpModifier() * damageMult, 0.25));
        chiHit = (float)((double)chiHit * (damageMult * (double)abilityData.getXpModifier()));
        Vector vel = Vector.getVelocity((Entity)entity).withY(0.0);
        if (bender.consumeChi(chi)) {
            if (!this.getBooleanProperty(SHOCKWAVE, ctx)) {
                EntityFlames flames = new EntityFlames(world);
                flames.setVelocity(Vector.getLookRectangular((Entity)entity).times(speed).plus(vel));
                flames.setOwner(entity);
                flames.setPosition(pos.minusY(size / 2.0f));
                flames.field_70177_z = entity.field_70177_z;
                flames.field_70125_A = entity.field_70125_A;
                flames.setEntitySize(size);
                flames.setDynamicSpreadingCollision(false);
                flames.setReflect(this.getBooleanProperty(REFLECT, ctx));
                flames.setAbility(this);
                flames.setPerformanceAmount(performance);
                flames.setTier(this.getCurrentTier(ctx));
                flames.setXp(xp);
                flames.setSmelts(this.getBooleanProperty("smelts", ctx));
                flames.setLifeTime(lifeTime);
                flames.setTrailingFires(this.getBooleanProperty(TRAILING_FIRE, ctx));
                flames.setFireTime(fireTime);
                flames.setFires(this.getBooleanProperty("setsFires", ctx));
                flames.setDamage(damage);
                flames.setRGB(this.getProperty("fireR", ctx).intValue(), this.getProperty("fireG", ctx).intValue(), this.getProperty("fireB", ctx).intValue());
                flames.setFade(this.getProperty("fadeR", ctx).intValue(), this.getProperty("fadeG", ctx).intValue(), this.getProperty("fadeB", ctx).intValue());
                flames.setElement(new Firebending());
                flames.setPush(knockback);
                flames.setChiHit(chiHit);
                flames.setBehaviour(new FireShockwaveBehaviour());
                flames.setDamageSource("avatar_Fire_fireShot");
                world.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187557_bK, SoundCategory.PLAYERS, 1.75f + world.field_73012_v.nextFloat(), 0.5f + world.field_73012_v.nextFloat(), false);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)flames);
                }
                if (world.field_72995_K) {
                    for (double angle = 0.0; angle < 360.0; angle += 8.0) {
                        Vector position = Vector.getOrthogonalVector(entity.func_70040_Z(), angle, (double)(size / 20.0f));
                        position = position.plus(pos.minusY(0.05).plus(Vector.getLookRectangular((Entity)entity)));
                        Vector velocity = position.minus(pos.minusY(0.05).plus(Vector.getLookRectangular((Entity)entity))).normalize();
                        velocity = velocity.times(speed / 300.0f);
                        double spawnX = position.x();
                        double spawnY = position.y();
                        double spawnZ = position.z();
                        ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 80.0 + velocity.x(), world.field_73012_v.nextGaussian() / 80.0 + velocity.y(), world.field_73012_v.nextGaussian() / 80.0 + velocity.z()).time(8 + AvatarUtils.getRandomNumberInRange(0, 4)).clr(1.0f, 0.039215688f, 0.019607844f, 0.75f).spawnEntity((Entity)entity).scale(size / 2.0f).element(new Firebending()).collide(true).collideParticles(true).ability(this).spawn(world);
                        ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 80.0 + velocity.x(), world.field_73012_v.nextGaussian() / 80.0 + velocity.y(), world.field_73012_v.nextGaussian() / 80.0 + velocity.z()).time(12 + AvatarUtils.getRandomNumberInRange(0, 6)).clr(1.0f, (float)(40 + AvatarUtils.getRandomNumberInRange(0, 60)) / 255.0f, 0.039215688f, 0.75f).spawnEntity((Entity)entity).scale(size / 2.0f).element(new Firebending()).collide(true).collideParticles(true).ability(this).spawn(world);
                    }
                }
            } else {
                float radius = this.getProperty("effectRadius", ctx).floatValue();
                radius = (float)((double)radius * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
                EntityShockwave wave = new EntityShockwave(world);
                wave.setOwner(entity);
                wave.field_70125_A = entity.field_70125_A;
                wave.field_70177_z = entity.field_70177_z;
                wave.setPosition(entity.func_174791_d().func_72441_c(0.0, (double)(entity.func_70047_e() / 2.0f), 0.0));
                wave.setFireTime(fireTime);
                wave.setElement(new Firebending());
                wave.setAbility(this);
                wave.setParticle(AvatarParticles.getParticleFlames());
                wave.setDamage(damage);
                wave.setPerformanceAmount(performance);
                wave.setBehaviour(new FireShockwaveBehaviour());
                wave.setSpeed(speed);
                wave.setPush(knockback);
                wave.setKnockbackHeight(0.15);
                wave.setParticleSpeed(0.18f);
                wave.setParticleWaves(2);
                wave.setParticleAmount(10);
                wave.setRange(radius);
                world.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187557_bK, SoundCategory.PLAYERS, 1.75f + world.field_73012_v.nextFloat(), 0.5f + world.field_73012_v.nextFloat(), false);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)wave);
                }
            }
        }
    }

    @Override
    public BendingAi getAi(EntityLiving entity, Bender bender) {
        return new AiFireShot(this, entity, bender);
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean isOffensive() {
        return true;
    }

    public static class FireShockwaveBehaviour
    extends OffensiveBehaviour {
        public OffensiveBehaviour onUpdate(EntityOffensive entity) {
            block3: {
                block4: {
                    if (entity.getOwner() == null) break block3;
                    if (!(entity instanceof EntityShockwave)) break block4;
                    for (double angle = 0.0; angle < Math.PI * 2; angle += Math.PI / (double)(entity.field_70173_aa * 3)) {
                        int z;
                        int x = entity.field_70165_t < 0.0 ? (int)(entity.field_70165_t + (double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() * Math.sin(angle) - 1.0) : (int)(entity.field_70165_t + (double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() * Math.sin(angle));
                        BlockPos spawnPos = new BlockPos(x, (int)entity.field_70163_u, z = entity.field_70161_v < 0.0 ? (int)(entity.field_70161_v + ((double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() * Math.cos(angle) - 1.0)) : (int)(entity.field_70161_v + (double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() * Math.cos(angle)));
                        if (!BlockUtils.canPlaceFireAt(entity.field_70170_p, spawnPos) || spawnPos == entity.func_180425_c()) continue;
                        int time = (double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() >= ((EntityShockwave)entity).getRange() - 0.2 ? 120 : 10;
                        BlockTemp.createTempBlock(entity.field_70170_p, spawnPos, time, Blocks.field_150480_ab.func_176223_P());
                    }
                    break block3;
                }
                if (!(entity instanceof EntityFlames) || !entity.field_70170_p.field_72995_K || entity.field_70173_aa <= 1) break block3;
                int[] fade = entity.getFade();
                int[] rgb = entity.getRGB();
                int h = 0;
                while ((double)h < Math.max(entity.velocity().magnitude() / 10.0, 1.0)) {
                    for (double i = 0.0; i < (double)entity.field_70130_N; i += 0.1 * (double)entity.getAvgSize() * 4.0) {
                        int rRandom = fade[0] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[0] * 2) : AvatarUtils.getRandomNumberInRange(fade[0] / 2, fade[0] * 2);
                        int gRandom = fade[1] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[1] * 2) : AvatarUtils.getRandomNumberInRange(fade[1] / 2, fade[1] * 2);
                        int bRandom = fade[2] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[2] * 2) : AvatarUtils.getRandomNumberInRange(fade[2] / 2, fade[2] * 2);
                        Random random = new Random();
                        AxisAlignedBB boundingBox = entity.func_174813_aQ();
                        double spawnX = boundingBox.field_72340_a + random.nextDouble() * (boundingBox.field_72336_d - boundingBox.field_72340_a);
                        double spawnY = boundingBox.field_72338_b + random.nextDouble() * (boundingBox.field_72337_e - boundingBox.field_72338_b);
                        double spawnZ = boundingBox.field_72339_c + random.nextDouble() * (boundingBox.field_72334_f - boundingBox.field_72339_c);
                        ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(entity.field_70170_p.field_73012_v.nextGaussian() / 60.0, entity.field_70170_p.field_73012_v.nextGaussian() / 60.0, entity.field_70170_p.field_73012_v.nextGaussian() / 60.0).time(12 - (int)(entity.velocity().magnitude() / 10.0) + AvatarUtils.getRandomNumberInRange(2, 4)).clr(rgb[0], rgb[1], rgb[2]).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(100, 175)).scale(entity.getAvgSize() * 1.75f).element(entity.getElement()).ability(entity.getAbility()).spawnEntity((Entity)entity.getOwner()).spawn(entity.field_70170_p);
                        ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(entity.field_70170_p.field_73012_v.nextGaussian() / 60.0, entity.field_70170_p.field_73012_v.nextGaussian() / 60.0, entity.field_70170_p.field_73012_v.nextGaussian() / 60.0).time(12 - (int)(entity.velocity().magnitude() / 10.0) + AvatarUtils.getRandomNumberInRange(2, 4)).clr(rgb[0], rgb[1], rgb[2]).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(100, 175)).scale(entity.getAvgSize() * 1.75f).element(entity.getElement()).ability(entity.getAbility()).spawnEntity((Entity)entity.getOwner()).spawn(entity.field_70170_p);
                        ParticleBuilder.create(ParticleBuilder.Type.FIRE).pos(AvatarEntityUtils.getMiddleOfEntity(entity)).vel(entity.field_70170_p.field_73012_v.nextGaussian() / 40.0, entity.field_70170_p.field_73012_v.nextGaussian() / 40.0, entity.field_70170_p.field_73012_v.nextGaussian() / 40.0).time(12 - (int)(entity.velocity().magnitude() / 10.0) + AvatarUtils.getRandomNumberInRange(2, 4)).scale(entity.getAvgSize() / 2.0f).element(entity.getElement()).ability(entity.getAbility()).spawnEntity((Entity)entity.getOwner()).spawn(entity.field_70170_p);
                    }
                    ++h;
                }
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

