/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingAi;
import com.crowsofwar.avatar.bending.bending.fire.AiFireball;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.entity.EntityFireball;
import com.crowsofwar.avatar.entity.data.FireballBehavior;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class AbilityFireball
extends Ability {
    public static final String FIREBALLS = "fireballs";

    public AbilityFireball() {
        super(Firebending.ID, "fireball");
        this.requireRaytrace(2.5, false);
    }

    @Override
    public void init() {
        super.init();
        this.addProperties("fireR", "fireG", "fireB", "fadeR", "fadeG", "fadeB", "explosionSize", "explosionDamage", "maxBurnout", "maxDamage", "maxSize", "maxExhaustion", FIREBALLS);
    }

    @Override
    public int getCooldown(AbilityContext ctx) {
        return 0;
    }

    @Override
    public float getBurnOut(AbilityContext ctx) {
        return 0.0f;
    }

    @Override
    public float getExhaustion(AbilityContext ctx) {
        return 0.0f;
    }

    @Override
    public void execute(AbilityContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        World world = ctx.getWorld();
        BendingData data = ctx.getData();
        AbilityData abilityData = ctx.getAbilityData();
        if (bender.consumeChi(this.getChiCost(ctx) / 4.0f)) {
            Vector target;
            if (ctx.isLookingAtBlock()) {
                target = Raytrace.getTargetBlock(entity, 2.5).getPosPrecise();
            } else {
                Vector playerPos = Vector.getEyePos((Entity)entity);
                target = playerPos.plus(Vector.getLookRectangular((Entity)entity).times(2.5));
            }
            float damage = this.getProperty("damage", ctx).floatValue();
            float size = this.getProperty("size", ctx).floatValue();
            int lifetime = this.getProperty("lifeTime", ctx).intValue();
            int fireballAmount = this.getProperty(FIREBALLS, ctx).intValue();
            int performance = this.getProperty("performanceAmount", ctx).intValue();
            int fireTime = this.getProperty("fireTime", ctx).intValue();
            float chiHit = this.getProperty("chiOnHit", ctx).floatValue();
            float explosionSize = this.getProperty("explosionSize", ctx).floatValue();
            float explosionDamage = this.getProperty("explosionDamage", ctx).floatValue();
            int r = this.getProperty("fireR", ctx).intValue();
            int g = this.getProperty("fireG", ctx).intValue();
            int b = this.getProperty("fireB", ctx).intValue();
            int fadeR = this.getProperty("fadeR", ctx).intValue();
            int fadeG = this.getProperty("fadeG", ctx).intValue();
            int fadeB = this.getProperty("fadeB", ctx).intValue();
            boolean canUse = !data.hasStatusControl(StatusControlController.THROW_FIREBALL);
            List fireballs = world.func_72872_a(EntityFireball.class, entity.func_174813_aQ().func_72314_b(3.5, 3.5, 3.5));
            fireballs = fireballs.stream().filter(entityFireball -> entityFireball.getOwner() == entity).collect(Collectors.toList());
            canUse |= fireballs.size() < fireballAmount;
            size = (float)((double)size * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            damage = (float)((double)damage * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            damage += size;
            explosionSize = (float)((double)explosionSize * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            explosionDamage = (float)((double)explosionDamage * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            chiHit = (float)((double)chiHit * abilityData.getDamageMult());
            lifetime = (int)((double)lifetime * (0.75 + 0.25 * abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            if (canUse) {
                assert (target != null);
                EntityFireball fireball = new EntityFireball(world);
                fireball.setPosition(target);
                fireball.setOwner(entity);
                fireball.setBehaviour(new FireballBehavior.PlayerControlled());
                fireball.setDamage(damage);
                fireball.setPowerRating(bender.calcPowerRating(Firebending.ID));
                fireball.setEntitySize(size);
                fireball.setLifeTime(lifetime);
                fireball.setPerformanceAmount(performance);
                fireball.setAbility(this);
                fireball.setChiHit(chiHit);
                fireball.setTier(this.getCurrentTier(ctx));
                fireball.setExplosionDamage(explosionDamage);
                fireball.setExplosionSize(explosionSize);
                fireball.setFireTime(fireTime);
                fireball.setDamageSource("avatar_Fire_fireball");
                fireball.setRGB(r, g, b);
                fireball.setRedirectable(true);
                fireball.setFade(fadeR, fadeG, fadeB);
                fireball.setXp(this.getProperty("xpOnHit", ctx).floatValue());
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)fireball);
                }
                abilityData.setRegenBurnout(false);
                data.addStatusControl(StatusControlController.THROW_FIREBALL);
            }
        }
    }

    @Override
    public BendingAi getAi(EntityLiving entity, Bender bender) {
        return new AiFireball(this, entity, bender);
    }

    @Override
    public int getBaseTier() {
        return 3;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean isOffensive() {
        return true;
    }
}

