/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingAi;
import com.crowsofwar.avatar.bending.bending.fire.AiFlameGlide;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import net.minecraft.entity.EntityLiving;

public class AbilityFlameGlide
extends Ability {
    public static final String JET_STREAM = "jetStream";

    public AbilityFlameGlide() {
        super(Firebending.ID, "flame_glide");
    }

    @Override
    public void init() {
        this.addProperties("tier", "chiCost", "burnOut", "burnOutRecoverTick", "cooldown", "exhaustion", "speed", "chiOnHit", "performanceAmount", "xpOnHit", "size", "knockback", "damage", "xpOnUse", "fireTime");
        this.addProperties("duration", "fireR", "fireG", "fireB", "fadeR", "fadeG", "fadeB", "fallAbsorption");
        this.addBooleanProperties("stopShockwave", JET_STREAM);
    }

    @Override
    public boolean isUtility() {
        return true;
    }

    @Override
    public boolean isOffensive() {
        return true;
    }

    @Override
    public void execute(AbilityContext ctx) {
        BendingData data = ctx.getData();
        Bender bender = ctx.getBender();
        AbilityData abilityData = ctx.getAbilityData();
        if (!data.hasStatusControl(StatusControlController.FIRE_JUMP) && bender.consumeChi(this.getChiCost(abilityData) / 8.0f)) {
            data.addStatusControl(StatusControlController.FIRE_JUMP);
            if (data.hasTickHandler(TickHandlerController.FLAME_GLIDE_HANDLER)) {
                StatusControl sc = StatusControlController.FIRE_JUMP;
                Raytrace.Result raytrace = Raytrace.getTargetBlock(ctx.getBenderEntity(), -1.0);
                if (sc.execute(new BendingContext(data, ctx.getBenderEntity(), ctx.getBender(), raytrace))) {
                    data.removeStatusControl(sc);
                }
            }
        }
    }

    @Override
    public int getCooldown(AbilityContext ctx) {
        return 0;
    }

    @Override
    public float getBurnOut(AbilityContext ctx) {
        return 0.0f;
    }

    @Override
    public float getExhaustion(AbilityContext ctx) {
        return 0.0f;
    }

    @Override
    public BendingAi getAi(EntityLiving entity, Bender bender) {
        return new AiFlameGlide(this, entity, bender);
    }
}

