/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingAi;
import com.crowsofwar.avatar.bending.bending.fire.AiFlameStrike;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.config.ConfigClient;
import com.crowsofwar.avatar.entity.EntityLightOrb;
import com.crowsofwar.avatar.entity.data.LightOrbBehavior;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class AbilityFlameStrike
extends Ability {
    public static final String STRIKES = "numberOfStrikes";

    public AbilityFlameStrike() {
        super(Firebending.ID, "flame_strike");
        this.requireRaytrace(-1.0, false);
    }

    @Override
    public void init() {
        super.init();
        this.addProperties("fireR", "fireG", "fireB", "fadeR", "fadeG", "fadeB", STRIKES);
        this.addBooleanProperties("setsFires", "smelts");
    }

    @Override
    public void execute(AbilityContext ctx) {
        BendingData data = ctx.getData();
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        World world = ctx.getWorld();
        if (data.hasStatusControl(StatusControlController.FLAME_STRIKE_MAIN) || data.hasStatusControl(StatusControlController.FLAME_STRIKE_OFF)) {
            return;
        }
        float orbSize = 0.3f;
        int lightRadius = 4;
        if (ctx.getLevel() == 1) {
            lightRadius += 2;
            orbSize += 0.1f;
        }
        if (ctx.getLevel() == 2) {
            lightRadius += 4;
            orbSize += 0.2f;
        }
        if (ctx.isMasterLevel(AbilityData.AbilityTreePath.FIRST)) {
            lightRadius += 8;
            orbSize += 0.4f;
        }
        if (ctx.isMasterLevel(AbilityData.AbilityTreePath.SECOND)) {
            lightRadius += 3;
            orbSize += 0.15f;
        }
        if (bender.consumeChi(this.getChiCost(ctx) / 4.0f)) {
            Vec3d height = entity.func_174791_d().func_72441_c(0.0, 1.8, 0.0);
            Vec3d rightSide = Vector.toRectangular(Math.toRadians(entity.field_70177_z + 90.0f), 0.0).times(0.05).withY(0.0).toMinecraft();
            rightSide = rightSide.func_178787_e(height);
            if (AvatarMod.hammerCore) {
                EntityLightOrb orb = new EntityLightOrb(world);
                orb.setOwner(entity);
                orb.setAbility(new AbilityFlameStrike());
                orb.setPosition(rightSide);
                orb.setOrbSize(orbSize);
                orb.setInitialSize(orbSize);
                orb.setSpinning(true);
                orb.setColor(1.0f, 0.3f, 0.0f, 1.0f);
                orb.setLightRadius(lightRadius);
                orb.setEmittingEntity((Entity)entity);
                orb.setColourShiftRange(0.8f);
                orb.setColourShiftInterval(0.15f);
                orb.setBehavior(new FlameStrikeLightOrb());
                ConfigClient.CLIENT_CONFIG.fireRenderSettings.getClass();
                orb.setType(EntityLightOrb.EnumType.COLOR_CUBE);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)orb);
                }
            }
        }
        ctx.getAbilityData().setRegenBurnout(false);
        ctx.getAbilityData().setUseNumber(0);
        data.addTickHandler(TickHandlerController.FLAME_STRIKE_HANDLER, ctx);
        data.addStatusControl(StatusControlController.FLAME_STRIKE_MAIN);
        super.execute(ctx);
    }

    @Override
    public BendingAi getAi(EntityLiving entity, Bender bender) {
        return new AiFlameStrike(this, entity, bender, 1.2, false);
    }

    @Override
    public boolean isOffensive() {
        return true;
    }

    @Override
    public int getCooldown(AbilityContext ctx) {
        return 0;
    }

    @Override
    public float getBurnOut(AbilityContext ctx) {
        return 0.0f;
    }

    @Override
    public float getExhaustion(AbilityContext ctx) {
        return 0.0f;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    public static class FlameStrikeLightOrb
    extends LightOrbBehavior {
        public LightOrbBehavior onUpdate(EntityLightOrb entity) {
            BendingData be;
            Entity emitter = entity.getEmittingEntity();
            if (emitter != null && (emitter instanceof EntityBender || emitter instanceof EntityPlayer) && (be = BendingData.getFromEntity((EntityLivingBase)emitter)) != null) {
                boolean hasStatCtrl;
                boolean bl = hasStatCtrl = be.hasStatusControl(StatusControlController.FLAME_STRIKE_MAIN) || be.hasStatusControl(StatusControlController.FLAME_STRIKE_OFF);
                if (hasStatCtrl) {
                    ConfigClient.CLIENT_CONFIG.fireRenderSettings.getClass();
                    entity.setOrbSize(0.005f);
                    entity.setPosition(AvatarEntityUtils.getMiddleOfEntity(emitter));
                    if (entity.field_70173_aa % 6 == 0 && entity.getColourShiftRange() != 0.0f) {
                        float range = entity.getColourShiftRange() / 2.0f;
                        float r = entity.getInitialColourR();
                        float g = entity.getInitialColourG();
                        float b = entity.getInitialColourB();
                        float a = entity.getInitialColourA();
                        block6: for (int i = 0; i < 4; ++i) {
                            float rMin = r < range ? 0.0f : r - range;
                            float gMin = g < range ? 0.0f : r - range;
                            float bMin = b < range ? 0.0f : r - range;
                            float aMin = a < range ? 0.0f : a - range;
                            float rMax = r + range;
                            float gMax = b + range;
                            float bMax = g + range;
                            float aMax = a + range;
                            switch (i) {
                                case 0: {
                                    float amountR = (float)AvatarUtils.getRandomNumberInRange(0, (int)(100.0f / rMax)) / 100.0f * entity.getColourShiftInterval();
                                    float red = entity.field_70170_p.field_73012_v.nextBoolean() ? r + amountR : r - amountR;
                                    red = MathHelper.func_76131_a((float)red, (float)rMin, (float)rMax);
                                    entity.setColorR(red);
                                    continue block6;
                                }
                                case 1: {
                                    float amountG = (float)AvatarUtils.getRandomNumberInRange(0, (int)(100.0f / gMax)) / 100.0f * entity.getColourShiftInterval();
                                    float green = entity.field_70170_p.field_73012_v.nextBoolean() ? g + amountG : g - amountG;
                                    green = MathHelper.func_76131_a((float)green, (float)gMin, (float)gMax);
                                    entity.setColorG(green);
                                    continue block6;
                                }
                                case 2: {
                                    float amountB = (float)AvatarUtils.getRandomNumberInRange(0, (int)(100.0f / bMax)) / 100.0f * entity.getColourShiftInterval();
                                    float blue = entity.field_70170_p.field_73012_v.nextBoolean() ? b + amountB : b - amountB;
                                    blue = MathHelper.func_76131_a((float)blue, (float)bMin, (float)bMax);
                                    entity.setColorB(blue);
                                    continue block6;
                                }
                                case 3: {
                                    float amountA = (float)AvatarUtils.getRandomNumberInRange(0, (int)(100.0f / aMax)) / 100.0f * entity.getColourShiftInterval();
                                    float alpha = entity.field_70170_p.field_73012_v.nextBoolean() ? a + amountA : a - amountA;
                                    alpha = MathHelper.func_76131_a((float)alpha, (float)aMin, (float)aMax);
                                    entity.setColorA(alpha);
                                }
                            }
                        }
                    }
                } else {
                    entity.func_70106_y();
                }
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

