/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.bending.bending.fire.powermods.ImmolatePowerModifier;
import com.crowsofwar.avatar.entity.EntityLightOrb;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.entity.data.LightOrbBehavior;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class AbilityImmolate
extends Ability {
    public static final String INCINERATE_PROJECTILES = "projectileIncineration";
    public static final String FIRE_CHANCE = "fireChance";

    public AbilityImmolate() {
        super(Firebending.ID, "immolate");
    }

    @Override
    public void init() {
        super.init();
        this.addProperties(FIRE_CHANCE, "strengthLevel", "strengthDuration", "healthLevel", "healthDuration", "speedLevel", "speedDuration", "fireR", "fireG", "fireB", "fadeR", "fadeG", "fadeB");
        this.addBooleanProperties(INCINERATE_PROJECTILES);
    }

    @Override
    public boolean isBuff() {
        return true;
    }

    @Override
    public void execute(AbilityContext ctx) {
        BendingData data = ctx.getData();
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        World world = ctx.getWorld();
        AbilityData abilityData = data.getAbilityData(this);
        float chi = this.getChiCost(ctx);
        if (bender.consumeChi(chi)) {
            int duration = this.getProperty("duration", ctx).intValue();
            int strengthLevel = this.getProperty("strengthLevel", ctx).intValue();
            int strengthDuration = this.getProperty("strengthDuration", ctx).intValue();
            int healthLevel = this.getProperty("healthLevel", ctx).intValue();
            int healthDuration = this.getProperty("healthDuration", ctx).intValue();
            int speedLevel = this.getProperty("speedLevel", ctx).intValue();
            int speedDuration = this.getProperty("speedDuration", ctx).intValue();
            int lightRadius = 5;
            if ((double)(this.getProperty(FIRE_CHANCE, ctx).floatValue() / 10.0f) > 0.5) {
                entity.func_70015_d(1);
            }
            if (abilityData.getLevel() == 1) {
                lightRadius = 7;
            }
            if (abilityData.getLevel() == 2) {
                lightRadius = 10;
            }
            if (abilityData.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
                lightRadius = 9;
            }
            if (abilityData.isMasterPath(AbilityData.AbilityTreePath.SECOND)) {
                lightRadius = 12;
            }
            speedDuration = (int)((double)speedDuration * (ctx.getPowerRatingDamageMod() * (double)abilityData.getXpModifier()));
            strengthDuration = (int)((double)strengthDuration * (ctx.getPowerRatingDamageMod() * (double)abilityData.getXpModifier()));
            healthDuration = (int)((double)healthDuration * (ctx.getPowerRatingDamageMod() * (double)abilityData.getXpModifier()));
            if (strengthLevel > 0) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, strengthDuration, strengthLevel - 1, false, false));
            }
            if (healthLevel > 0) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_180152_w, healthDuration, healthLevel - 1, false, false));
            }
            if (speedLevel > 0) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76424_c, speedDuration, speedLevel - 1, false, false));
            }
            if (data.hasBendingId(this.getBendingId())) {
                ImmolatePowerModifier modifier = new ImmolatePowerModifier();
                modifier.setTicks(duration);
                data.getPowerRatingManager(this.getBendingId()).addModifier(modifier, ctx);
            }
            EntityLightOrb orb = new EntityLightOrb(world);
            orb.setOwner(entity);
            orb.setAbility(this);
            orb.setPosition(new Vec3d(entity.field_70165_t, entity.func_174813_aQ().field_72338_b + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v));
            orb.setOrbSize(0.005f);
            orb.setLifeTime(duration);
            orb.setColor(1.0f, 0.5f, 0.0f, 3.0f);
            orb.setLightRadius(lightRadius);
            orb.setEmittingEntity((Entity)entity);
            orb.setBehavior(new ImmolateLightOrbBehaviour());
            orb.setType(EntityLightOrb.EnumType.COLOR_CUBE);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)orb);
            }
            abilityData.addXp(this.getProperty("xpOnUse", ctx).floatValue());
            data.addTickHandler(TickHandlerController.PURIFY_PARTICLE_SPAWNER, ctx);
        }
    }

    @Override
    public int getBaseTier() {
        return 5;
    }

    public static class ImmolateLightOrbBehaviour
    extends LightOrbBehavior.FollowPlayer {
        @Override
        public Behavior<EntityLightOrb> onUpdate(EntityLightOrb entity) {
            super.onUpdate(entity);
            EntityLivingBase emitter = entity.getOwner();
            if (emitter != null) {
                AbilityData aD;
                assert (emitter instanceof EntityPlayer || emitter instanceof EntityBender);
                Bender b = Bender.get(emitter);
                if (b != null && BendingData.getFromEntity(emitter) != null && entity.field_70173_aa > 1 && !Objects.requireNonNull(b.getData().getPowerRatingManager(Firebending.ID)).hasModifier(ImmolatePowerModifier.class)) {
                    entity.func_70106_y();
                }
                int lightRadius = 5;
                if (entity.field_70173_aa == 1 && (aD = AbilityData.get(emitter, "immolate")) != null) {
                    int level = aD.getLevel();
                    if (level >= 1) {
                        lightRadius = 7;
                    }
                    if (level >= 2) {
                        lightRadius = 10;
                    }
                    if (aD.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
                        lightRadius = 9;
                    }
                    if (aD.isMasterPath(AbilityData.AbilityTreePath.SECOND)) {
                        lightRadius = 12;
                    }
                }
                if (entity.func_130014_f_().field_72995_K) {
                    entity.setLightRadius(lightRadius + (int)(Math.random() * 5.0));
                }
                return this;
            }
            entity.func_70106_y();
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
            super.fromBytes(buf);
        }

        @Override
        public void toBytes(PacketBuffer buf) {
            super.toBytes(buf);
        }

        @Override
        public void load(NBTTagCompound nbt) {
            super.load(nbt);
        }

        @Override
        public void save(NBTTagCompound nbt) {
            super.save(nbt);
        }
    }
}

