/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityFireball;
import com.crowsofwar.avatar.entity.data.FireballBehavior;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class AbilitySwirlingInferno
extends Ability {
    public AbilitySwirlingInferno() {
        super(Firebending.ID, "swirling_inferno");
    }

    @Override
    public void execute(AbilityContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        World world = ctx.getWorld();
        BendingData data = ctx.getData();
        if (bender.consumeChi(ConfigStats.STATS_CONFIG.chiFireball)) {
            Vector target;
            if (ctx.isLookingAtBlock() && !world.field_72995_K) {
                target = ctx.getLookPos();
            } else {
                Vector playerPos = Vector.getEyePos((Entity)entity);
                target = playerPos.plus(Vector.getLookRectangular((Entity)entity).times(2.5));
            }
            float damage = ConfigStats.STATS_CONFIG.fireballSettings.damage;
            int size = 16;
            boolean canUse = !data.hasStatusControl(StatusControlController.THROW_FIREBALL);
            List fireballs = world.func_72872_a(EntityFireball.class, entity.func_174813_aQ().func_72314_b(3.5, 3.5, 3.5));
            canUse |= fireballs.size() < 3 && ctx.isDynamicMasterLevel(AbilityData.AbilityTreePath.FIRST);
            damage *= ctx.getLevel() >= 2 ? 1.75f : 1.0f;
            damage = (float)((double)damage * ctx.getPowerRatingDamageMod());
            if (ctx.getLevel() == 1) {
                size = 18;
            }
            if (ctx.getLevel() == 2) {
                size = 20;
            }
            if (ctx.isMasterLevel(AbilityData.AbilityTreePath.FIRST)) {
                size = 18;
                damage -= 2.0f;
            }
            if (ctx.isDynamicMasterLevel(AbilityData.AbilityTreePath.SECOND)) {
                size = 20;
            }
            damage += (float)size / 10.0f;
            if (canUse) {
                assert (target != null);
                EntityFireball fireball = new EntityFireball(world);
                fireball.setPosition(target);
                fireball.setOwner(entity);
                fireball.setBehaviour(new FireballBehavior.PlayerControlled());
                fireball.setDamage(damage);
                fireball.setPowerRating(bender.calcPowerRating(Firebending.ID));
                fireball.setEntitySize((float)size / 16.0f);
                fireball.setLifeTime(30);
                fireball.setPerformanceAmount(24);
                fireball.setAbility(this);
                fireball.setFireTime(size / 5);
                fireball.setXp(ConfigSkills.SKILLS_CONFIG.fireballHit);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)fireball);
                }
                data.addStatusControl(StatusControlController.THROW_FIREBALL);
            }
        }
    }

    @Override
    public int getBaseTier() {
        return 5;
    }

    @Override
    public boolean isChargeable() {
        return true;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean isOffensive() {
        return true;
    }
}

