/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingAi;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityFireball;
import com.crowsofwar.avatar.entity.data.FireballBehavior;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.StatusControlController;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;

public class AiFireball
extends BendingAi {
    protected AiFireball(Ability ability, EntityLiving entity, Bender bender) {
        super(ability, entity, bender);
        this.func_75248_a(3);
    }

    @Override
    protected void startExec() {
        this.execAbility();
    }

    @Override
    protected boolean shouldExec() {
        EntityLivingBase target = this.entity.func_70638_az();
        return target != null;
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        for (int i = 0; i < 3; ++i) {
            EntityFireball fireball = AvatarEntity.lookupEntity(this.entity.field_70170_p, EntityFireball.class, fire -> fire.getBehaviour() instanceof FireballBehavior.PlayerControlled && fire.getOwner() == this.entity);
            if (fireball == null) continue;
            fireball.func_70106_y();
            this.cleanUp();
        }
    }

    @Override
    public int getTotalDuration() {
        AbilityData abilityData = this.bender.getData().getAbilityData(this.ability);
        int duration = 40;
        float maxSize = this.ability.getProperty("maxSize", abilityData).floatValue();
        float size = this.ability.getProperty("size", abilityData).floatValue();
        int fireballs = (int)this.entity.field_70170_p.func_72872_a(EntityFireball.class, this.entity.func_174813_aQ().func_72314_b(3.5, 3.0, 3.5)).stream().filter(entityFireball -> entityFireball.getOwner() == this.entity && entityFireball.getBehaviour() instanceof FireballBehavior.PlayerControlled).count();
        if (maxSize > size) {
            duration = (int)((float)duration * (maxSize / size));
        }
        return duration *= Math.max(1, fireballs);
    }

    @Override
    public int getWaitDuration() {
        return 15;
    }

    @Override
    public StatusControl[] getStatusControls() {
        return new StatusControl[]{StatusControlController.THROW_FIREBALL};
    }

    @Override
    public boolean shouldExecStatCtrl(StatusControl statusControl) {
        if (statusControl == StatusControlController.THROW_FIREBALL) {
            return this.timeExecuting > 0 && this.timeExecuting % this.getWaitDuration() == 0 && this.bender.getData().getAbilityData(this.ability).getAbilityCooldown() <= 0;
        }
        return super.shouldExecStatCtrl(statusControl);
    }

    @Override
    public float getMaxTargetRange() {
        return 10.0f;
    }

    @Override
    public float getMinTargetRange() {
        return 2.5f;
    }
}

