/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire;

import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.bending.bending.fire.statctrls.StatCtrlFireRedirect;
import com.crowsofwar.avatar.bending.bending.fire.statctrls.StatCtrlFireSplit;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.StatusControlController;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="avatarmod")
public class FireRedirectHandler {
    @SubscribeEvent
    public static void controlRedirect(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (BendingData.getFromEntity(entity) != null) {
            BendingData data = BendingData.getFromEntity(entity);
            assert (data != null);
            boolean removeRedirect = false;
            boolean removeSplit = false;
            if (data.hasBending(new Firebending()) && !entity.field_70170_p.field_72995_K) {
                if (AbilityData.get(entity, "fire_redirect") != null && Objects.requireNonNull(AbilityData.get(entity, "fire_redirect")).getLevel() > -1) {
                    List<StatusControl> controls;
                    AbilityData abilityData = AbilityData.get(entity, "fire_redirect");
                    if (data.getAllStatusControls() != null && !(controls = data.getAllStatusControls()).isEmpty()) {
                        if (controls.contains(StatusControlController.REDIRECT_FIRE)) {
                            for (StatusControl sc : controls) {
                                if (sc instanceof StatCtrlFireRedirect || sc.getSubscribedControl() != AvatarControl.CONTROL_SHIFT) continue;
                                removeRedirect = true;
                            }
                        }
                        if (controls.contains(StatusControlController.SPLIT_FIRE)) {
                            for (StatusControl sc : controls) {
                                if (sc instanceof StatCtrlFireSplit || sc.getSubscribedControl() != AvatarControl.CONTROL_RIGHT_CLICK && sc.getSubscribedControl() != AvatarControl.CONTROL_RIGHT_CLICK_DOWN && sc.getSubscribedControl() != AvatarControl.CONTROL_RIGHT_CLICK_UP) continue;
                                removeSplit = true;
                            }
                        }
                    }
                }
                if (removeRedirect) {
                    data.removeStatusControl(StatusControlController.REDIRECT_FIRE);
                } else if (entity.field_70173_aa % 20 == 0) {
                    data.addStatusControl(StatusControlController.REDIRECT_FIRE);
                }
                if (removeSplit) {
                    data.removeStatusControl(StatusControlController.SPLIT_FIRE);
                } else if (entity.field_70173_aa % 20 == 0) {
                    data.addStatusControl(StatusControlController.SPLIT_FIRE);
                }
            }
        }
    }
}

