/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire.powermods;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.BuffPowerModifier;
import com.crowsofwar.avatar.bending.bending.fire.AbilityImmolate;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.Vision;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.math.AxisAlignedBB;

public class ImmolatePowerModifier
extends BuffPowerModifier {
    @Override
    public double get(BendingContext ctx) {
        BendingData data = ctx.getData();
        AbilityData abilityData = data.getAbilityData(new AbilityImmolate().getName());
        return Objects.requireNonNull(Abilities.get("immolate")).getProperty("powerrating", abilityData).doubleValue();
    }

    @Override
    public boolean onUpdate(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        AbilityData abilityData = AbilityData.get(entity, "immolate");
        if (entity.field_70173_aa % 15 == 0) {
            double chance = Objects.requireNonNull(Abilities.get("immolate")).getProperty("fireChance", abilityData).floatValue() / 10.0f;
            if (Math.random() < chance) {
                entity.func_70015_d(2);
            }
        }
        if (Objects.requireNonNull(Abilities.get("immolate")).getBooleanProperty("projectileIncineration", abilityData)) {
            AxisAlignedBB box = new AxisAlignedBB(entity.field_70165_t - 2.0, entity.field_70163_u, entity.field_70161_v - 2.0, entity.field_70165_t + 2.0, entity.field_70163_u + 3.0, entity.field_70161_v + 2.0);
            List targets = entity.field_70170_p.func_72872_a(Entity.class, box);
            if (!entity.field_70170_p.field_72995_K && !targets.isEmpty()) {
                for (Entity e : targets) {
                    if ((!(e instanceof AvatarEntity) || !((AvatarEntity)e).canCollideWith((Entity)entity)) && e == entity) continue;
                    e.func_70015_d(5);
                    if (e instanceof EntityThrowable || e instanceof EntityItem) {
                        e.func_70015_d(1);
                        e.func_70106_y();
                    }
                    if (!(e instanceof EntityArrow)) continue;
                    e.func_70015_d(1);
                    e.func_70106_y();
                }
            }
        }
        return super.onUpdate(ctx);
    }

    @Override
    protected Vision[] getVisions() {
        return new Vision[]{Vision.IMMOLATE_WEAK, Vision.IMMOLATE_MEDIUM, Vision.IMMOLATE_POWERFUL};
    }

    @Override
    protected String getAbilityName() {
        return new AbilityImmolate().getName();
    }
}

