/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire.statctrls;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.fire.AbilityFlameGlide;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.bending.bending.fire.tickhandlers.FlameGlideHandler;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.entity.EntityShockwave;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StatCtrlFireJump
extends StatusControl {
    public StatCtrlFireJump() {
        super(15, AvatarControl.CONTROL_JUMP, StatusControl.CrosshairPosition.BELOW_CROSSHAIR);
    }

    @Override
    public boolean execute(BendingContext ctx) {
        Bender bender = ctx.getBender();
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        World world = ctx.getWorld();
        AbilityData abilityData = data.getAbilityData("flame_glide");
        AbilityFlameGlide jump = (AbilityFlameGlide)Abilities.get("flame_glide");
        if (jump != null) {
            float chiCost = jump.getChiCost(abilityData);
            float exhaustion = jump.getExhaustion(abilityData);
            float burnOut = jump.getBurnOut(abilityData);
            int cooldown = jump.getCooldown(abilityData);
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                cooldown = 0;
                exhaustion = burnOut = (float)0;
                chiCost = burnOut;
            }
            if (entity instanceof EntityBender) {
                chiCost = 0.0f;
            }
            if (bender.consumeChi(chiCost)) {
                float pitch;
                double jumpMultiplier = jump.getProperty("speed", abilityData).doubleValue() / 20.0;
                float fallAbsorption = jump.getProperty("fallAbsorption", abilityData).floatValue();
                Vector deltaPos = new Vector(entity.field_70165_t - entity.field_70142_S, 0.0, entity.field_70161_v - entity.field_70136_U);
                double currentYaw = Vector.getRotationTo(Vector.ZERO, deltaPos).y();
                if (deltaPos.sqrMagnitude() <= 0.001) {
                    currentYaw = Math.toRadians(entity.field_70177_z);
                }
                if ((pitch = entity.field_70125_A) < -45.0f) {
                    pitch = -45.0f;
                }
                Vector rotations = new Vector(Math.toRadians(pitch), currentYaw, 0.0);
                Vector velocity = rotations.toRectangular();
                velocity = velocity.withX(velocity.x() * 2.0);
                velocity = velocity.withY(velocity.y() * 0.25);
                velocity = velocity.withZ(velocity.z() * 2.0);
                velocity = velocity.times(jumpMultiplier);
                entity.func_70024_g(velocity.x(), velocity.y(), velocity.z());
                AvatarUtils.afterVelocityAdded((Entity)entity);
                IBlockState state = world.func_180495_p(entity.func_180425_c());
                Block currentBlock = state.func_177230_c();
                if (!(currentBlock instanceof BlockLiquid || state.func_185913_b() || state.func_185917_h())) {
                    this.damageNearbyEntities(ctx);
                }
                data.addTickHandler(TickHandlerController.FLAME_GLIDE_HANDLER, ctx);
                data.getMiscData().setFallAbsorption(fallAbsorption);
                abilityData.addXp(jump.getProperty("xpOnUse", abilityData).floatValue());
                entity.field_70170_p.func_184133_a(null, new BlockPos((Entity)entity), SoundEvents.field_187557_bK, SoundCategory.PLAYERS, 1.0f, 0.7f);
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_71020_j(exhaustion);
                }
                abilityData.addBurnout(burnOut);
                abilityData.setAbilityCooldown(cooldown == 0 ? 0 : jump.getCooldown(abilityData) - jump.getProperty("duration", abilityData).intValue());
                return true;
            }
        }
        return false;
    }

    private void damageNearbyEntities(BendingContext ctx) {
        World world = ctx.getWorld();
        EntityLivingBase entity = ctx.getBenderEntity();
        AbilityData abilityData = ctx.getData().getAbilityData("flame_glide");
        AbilityFlameGlide jump = (AbilityFlameGlide)Abilities.get("flame_glide");
        if (jump != null) {
            float speed = jump.getProperty("speed", abilityData).floatValue() / 10.0f;
            float size = jump.getProperty("size", abilityData).floatValue() / 2.0f;
            int lifetime = (int)(speed / size * 10.0f);
            float knockback = jump.getProperty("knockback", abilityData).floatValue();
            float damage = jump.getProperty("damage", abilityData).floatValue();
            int fireTime = jump.getProperty("fireTime", abilityData).intValue();
            int performance = jump.getProperty("performanceAmount", abilityData).intValue() / 10;
            float chiHit = jump.getProperty("chiOnHit", abilityData).floatValue() / 4.0f;
            int r = jump.getProperty("fireR", abilityData).intValue();
            int g = jump.getProperty("fireG", abilityData).intValue();
            int b = jump.getProperty("fireB", abilityData).intValue();
            int fadeR = jump.getProperty("fadeR", abilityData).intValue();
            int fadeG = jump.getProperty("fadeG", abilityData).intValue();
            int fadeB = jump.getProperty("fadeB", abilityData).intValue();
            speed = (float)((double)speed * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            size = (float)((double)size * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            lifetime = (int)((double)lifetime * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            knockback = (float)((double)knockback * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            damage = (float)((double)damage * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            fireTime = (int)((double)fireTime * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            performance = (int)((double)performance * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            chiHit = (float)((double)chiHit * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            EntityShockwave wave = new EntityShockwave(world);
            wave.setOwner(entity);
            wave.setDamageSource("avatar_Fire_shockwave");
            wave.setPosition(AvatarEntityUtils.getBottomMiddleOfEntity((Entity)entity).func_72441_c(0.0, 0.5, 0.0));
            wave.setFireTime(fireTime);
            wave.setEntitySize(size / 5.0f);
            wave.setElement(new Firebending());
            wave.setAbility(jump);
            wave.setDamage(damage);
            wave.setOwner(entity);
            wave.setSphere(false);
            wave.setSpeed(speed);
            wave.setRenderNormal(false);
            wave.setRange(size);
            wave.setLifeTime(lifetime);
            wave.setChiHit(chiHit);
            wave.setPerformanceAmount(performance);
            wave.setPush(knockback);
            wave.setParticleWaves(lifetime * 5);
            wave.setBehaviour(new FlameGlideHandler.FireJumpShockwave());
            wave.setParticleSpeed(speed / 30.0f);
            wave.setParticleAmount(30);
            wave.setRGB(r, g, b);
            wave.setFade(fadeR, fadeG, fadeB);
            wave.setXp(jump.getProperty("xpOnHit", abilityData).floatValue());
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)wave);
            }
        }
    }
}

