/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire.statctrls;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.fire.AbilityFireRedirect;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.bending.bending.fire.powermods.FireRedirectPowerModifier;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class StatCtrlFireRedirect
extends StatusControl {
    public StatCtrlFireRedirect() {
        super(100, AvatarControl.CONTROL_SHIFT, StatusControl.CrosshairPosition.BELOW_CROSSHAIR);
    }

    @Override
    public boolean execute(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        World world = ctx.getWorld();
        BendingData data = ctx.getData();
        Bender bender = ctx.getBender();
        AbilityData abilityData = data.getAbilityData(new AbilityFireRedirect());
        AbilityFireRedirect redirect = (AbilityFireRedirect)Abilities.get("fire_redirect");
        if (abilityData.getAbilityCooldown(entity) > 0) {
            return true;
        }
        if (redirect != null) {
            int cooldown = redirect.getCooldown(abilityData);
            float exhaustion = redirect.getExhaustion(abilityData);
            float burnout = redirect.getBurnOut(abilityData);
            float chiCost = redirect.getChiCost(abilityData);
            float xp = redirect.getProperty("xpOnUse", abilityData).floatValue();
            float radius = redirect.getProperty("radius", abilityData).floatValue();
            int redirectTier = redirect.getProperty("redirectTier", abilityData).intValue();
            boolean applyInhibitors = false;
            xp = (float)((double)xp * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            if (entity instanceof EntityBender || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                cooldown = 0;
                exhaustion = burnout = (float)0;
                chiCost = burnout;
            }
            List redirectables = world.func_72872_a(EntityOffensive.class, entity.func_174813_aQ().func_186662_g((double)radius));
            if (!(redirectables = redirectables.stream().filter(entityOffensive -> entityOffensive.canCollideWith((Entity)entity) && entityOffensive.isRedirectable() && entityOffensive.getElement() instanceof Firebending).collect(Collectors.toList())).isEmpty()) {
                for (EntityOffensive e : redirectables) {
                    if (e.getTier() > redirectTier || !bender.consumeChi(chiCost)) continue;
                    e.setOwner(entity);
                    if (redirect.getBooleanProperty("absorbFires") && e.getTier() <= redirect.getProperty("absorbTier", abilityData).intValue()) {
                        e.setBehaviour(new AbilityFireRedirect.AbsorbBehaviour());
                    } else {
                        e.setBehaviour(new OffensiveBehaviour.Redirect());
                    }
                    abilityData.addXp(xp);
                    applyInhibitors = true;
                }
            }
            if (redirect.getBooleanProperty("absorbFires", abilityData)) {
                BlockPos pos;
                int y;
                int x = 0;
                while ((float)x <= radius) {
                    int z = 0;
                    while ((float)z <= radius) {
                        y = 0;
                        while ((float)y <= radius) {
                            pos = new BlockPos(entity.field_70165_t + (double)x, entity.field_70163_u + (double)y, entity.field_70161_v + (double)z);
                            applyInhibitors = this.handleAbsorption(pos, world, redirect, abilityData, ctx, data, entity);
                            ++y;
                        }
                        ++z;
                    }
                    ++x;
                }
                x = 0;
                while ((float)x >= -radius) {
                    int z = 0;
                    while ((float)z >= -radius) {
                        y = 0;
                        while ((float)y >= -radius) {
                            pos = new BlockPos(entity.field_70165_t + (double)x, entity.field_70163_u + (double)y, entity.field_70161_v + (double)z);
                            applyInhibitors = this.handleAbsorption(pos, world, redirect, abilityData, ctx, data, entity);
                            --y;
                        }
                        --z;
                    }
                    --x;
                }
            }
            if (applyInhibitors) {
                abilityData.setAbilityCooldown(cooldown);
                abilityData.addBurnout(burnout);
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_71020_j(exhaustion);
                }
            }
        }
        return true;
    }

    public boolean handleAbsorption(BlockPos pos, World world, AbilityFireRedirect redirect, AbilityData abilityData, BendingContext ctx, BendingData data, EntityLivingBase entity) {
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockFire || world.func_180495_p(pos).func_177230_c() == Blocks.field_150480_ab) {
            if (world.field_72995_K) {
                for (int h = 0; h < 12; ++h) {
                    Vec3d spawnPos = new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p());
                    Vec3d endPos = Vector.getEyePos((Entity)entity).toMinecraft();
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos((double)pos.func_177958_n() + world.field_73012_v.nextGaussian() / 5.0, (double)pos.func_177956_o() + 0.5 + world.field_73012_v.nextGaussian() / 5.0, (double)pos.func_177952_p() + world.field_73012_v.nextGaussian() / 5.0).vel(endPos.func_178788_d(spawnPos).func_186678_a(0.15).func_72441_c(world.field_73012_v.nextGaussian() / 240.0, world.field_73012_v.nextGaussian() / 240.0, world.field_73012_v.nextGaussian() / 240.0)).scale(0.5f + world.field_73012_v.nextFloat() / 10.0f).clr(235 + AvatarUtils.getRandomNumberInRange(0, 20), 10 + AvatarUtils.getRandomNumberInRange(0, 20), 5 + AvatarUtils.getRandomNumberInRange(0, 10), 170 + AvatarUtils.getRandomNumberInRange(0, 40)).time(4 + AvatarUtils.getRandomNumberInRange(0, 4)).glow(true).spawn(world);
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos((double)pos.func_177958_n() + world.field_73012_v.nextGaussian() / 5.0, (double)pos.func_177956_o() + 0.5 + world.field_73012_v.nextGaussian() / 5.0, (double)pos.func_177952_p() + world.field_73012_v.nextGaussian() / 5.0).vel(endPos.func_178788_d(spawnPos).func_186678_a(0.15).func_72441_c(world.field_73012_v.nextGaussian() / 240.0, world.field_73012_v.nextGaussian() / 240.0, world.field_73012_v.nextGaussian() / 240.0)).scale(0.5f + world.field_73012_v.nextFloat() / 10.0f).clr(235 + AvatarUtils.getRandomNumberInRange(0, 20), 80 + AvatarUtils.getRandomNumberInRange(10, 40), 25 + AvatarUtils.getRandomNumberInRange(0, 20), 215 + AvatarUtils.getRandomNumberInRange(0, 40)).time(4 + AvatarUtils.getRandomNumberInRange(0, 4)).glow(true).spawn(world);
                }
            } else {
                world.func_175698_g(pos);
                FireRedirectPowerModifier powerMod = new FireRedirectPowerModifier();
                powerMod.setTicks(redirect.getProperty("powerDuration", abilityData).intValue());
                powerMod.setPowerRating(redirect.getProperty("powerBoost", abilityData).intValue());
                Objects.requireNonNull(data.getPowerRatingManager(Firebending.ID)).addModifier(powerMod, ctx);
            }
            return true;
        }
        return false;
    }
}

