/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire.statctrls;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.fire.AbilityFireRedirect;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class StatCtrlFireSplit
extends StatusControl {
    public StatCtrlFireSplit() {
        super(100, AvatarControl.CONTROL_RIGHT_CLICK, StatusControl.CrosshairPosition.RIGHT_OF_CROSSHAIR);
    }

    @Override
    public boolean execute(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        World world = ctx.getWorld();
        BendingData data = ctx.getData();
        Bender bender = ctx.getBender();
        AbilityData abilityData = data.getAbilityData(new AbilityFireRedirect());
        AbilityFireRedirect redirect = (AbilityFireRedirect)Abilities.get("fire_redirect");
        if (redirect != null) {
            List<Entity> destructables;
            int cooldown = redirect.getCooldown(abilityData);
            float exhaustion = redirect.getExhaustion(abilityData);
            float burnout = redirect.getBurnOut(abilityData);
            float chiCost = redirect.getChiCost(abilityData);
            float xp = redirect.getProperty("xpOnUse", abilityData).floatValue();
            float aimAssist = redirect.getProperty("aimAssist", abilityData).floatValue();
            float range = redirect.getProperty("range", abilityData).floatValue();
            int destroyTier = redirect.getProperty("destroyTier", abilityData).intValue();
            xp = (float)((double)xp * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                cooldown = 0;
                exhaustion = burnout = (float)0;
                chiCost = burnout;
            }
            if (entity instanceof EntityBender) {
                chiCost = 0.0f;
            }
            if (!(destructables = Raytrace.entityRaytrace(world, Vector.getEyePos((Entity)entity), Vector.getLookRectangular((Entity)entity), (double)range, aimAssist, entity1 -> entity1 instanceof EntityOffensive && ((EntityOffensive)entity1).canCollideWith((Entity)entity))).isEmpty()) {
                for (Entity e : destructables) {
                    if (!(e instanceof EntityOffensive) || ((EntityOffensive)e).getTier() > destroyTier) continue;
                    if (world.field_72995_K) {
                        for (int i = 0; i < 12; ++i) {
                            ParticleBuilder.create(ParticleBuilder.Type.FLASH).vel(entity.func_70040_Z().func_186678_a((double)range / 7.5).func_72441_c(world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0)).time((int)range * 4 + AvatarUtils.getRandomNumberInRange(0, 4)).scale(0.25f + range / 10.0f).pos(Vector.getEyePos((Entity)entity).toMinecraft()).clr(235 + AvatarUtils.getRandomNumberInRange(0, 20), 60 + AvatarUtils.getRandomNumberInRange(10, 40), 25 + AvatarUtils.getRandomNumberInRange(0, 10), 170 + AvatarUtils.getRandomNumberInRange(0, 20)).collide(true).collideParticles(true).element(new Firebending()).spawn(world);
                            ParticleBuilder.create(ParticleBuilder.Type.FLASH).vel(entity.func_70040_Z().func_186678_a((double)range / 7.5).func_72441_c(world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0)).time((int)range * 4 + AvatarUtils.getRandomNumberInRange(0, 4)).scale(0.25f + range / 10.0f).pos(Vector.getEyePos((Entity)entity).toMinecraft()).clr(255, 20 + AvatarUtils.getRandomNumberInRange(0, 20), 5 + AvatarUtils.getRandomNumberInRange(0, 10), 120 + AvatarUtils.getRandomNumberInRange(0, 20)).collide(true).collideParticles(true).element(new Firebending()).spawn(world);
                        }
                    }
                    if (!bender.consumeChi(chiCost)) continue;
                    ((EntityOffensive)e).Dissipate();
                    abilityData.setAbilityCooldown(cooldown);
                    abilityData.addBurnout(burnout);
                    if (entity instanceof EntityPlayer) {
                        ((EntityPlayer)entity).func_71020_j(exhaustion);
                    }
                    abilityData.addXp(xp);
                    entity.func_184609_a(EnumHand.MAIN_HAND);
                }
            }
        }
        return true;
    }
}

