/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire.statctrls;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.fire.AbilityFlameStrike;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.EntityFlames;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="avatarmod")
public class StatCtrlFlameStrike
extends StatusControl {
    EnumHand hand;

    public StatCtrlFlameStrike(EnumHand hand) {
        super(18, hand == EnumHand.MAIN_HAND ? AvatarControl.CONTROL_LEFT_CLICK : AvatarControl.CONTROL_RIGHT_CLICK, hand == EnumHand.MAIN_HAND ? StatusControl.CrosshairPosition.LEFT_OF_CROSSHAIR : StatusControl.CrosshairPosition.RIGHT_OF_CROSSHAIR);
        this.hand = hand;
    }

    @Override
    public boolean execute(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        World world = ctx.getWorld();
        AbilityData abilityData = ctx.getData().getAbilityData("flame_strike");
        Bender bender = Bender.get(entity);
        AbilityFlameStrike strike = (AbilityFlameStrike)Abilities.get(new AbilityFlameStrike().getName());
        if (strike == null || bender == null || !ctx.getData().hasTickHandler(TickHandlerController.FLAME_STRIKE_HANDLER)) {
            return true;
        }
        if (!entity.func_184586_b(this.hand).func_190926_b()) {
            return false;
        }
        float size = strike.getProperty("size", abilityData).floatValue();
        float accuracyMult = 0.05f;
        int particleCount = 3;
        double powerFactor = ctx.getBender().calcPowerRating(Firebending.ID) / 100.0;
        float powerModifier = (float)abilityData.getDamageMult();
        float xpMod = abilityData.getXpModifier();
        float damage = strike.getProperty("damage", abilityData).floatValue();
        int performance = strike.getProperty("performanceAmount", abilityData).intValue();
        int fireTime = strike.getProperty("fireTime", abilityData).intValue();
        float xp = strike.getProperty("xpOnHit", abilityData).floatValue();
        float mult = strike.getProperty("speed", abilityData).floatValue() / 10.0f;
        int lifeTime = strike.getProperty("lifeTime", abilityData).intValue();
        int r = strike.getProperty("fireR", abilityData).intValue();
        int g = strike.getProperty("fireG", abilityData).intValue();
        int b = strike.getProperty("fireB", abilityData).intValue();
        int fadeR = strike.getProperty("fadeR", abilityData).intValue();
        int fadeG = strike.getProperty("fadeG", abilityData).intValue();
        int fadeB = strike.getProperty("fadeB", abilityData).intValue();
        float burnout = strike.getBurnOut(abilityData);
        float chiCost = strike.getChiCost(abilityData);
        float exhaustion = strike.getExhaustion(abilityData);
        int cooldown = strike.getCooldown(abilityData);
        if (abilityData.getLevel() == 1) {
            particleCount += 2;
        }
        if (abilityData.getLevel() == 2) {
            particleCount += 4;
            accuracyMult *= 0.95f;
        }
        if (abilityData.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
            particleCount -= 2;
            accuracyMult = 0.04f;
        }
        if (abilityData.isMasterPath(AbilityData.AbilityTreePath.SECOND)) {
            particleCount += 2;
            accuracyMult *= 2.0f;
        }
        lifeTime = (int)((double)lifeTime + powerFactor * 3.0 * (double)xpMod);
        mult = (float)((double)mult + powerFactor / 10.0 * (double)xpMod);
        size *= powerModifier * xpMod;
        damage *= powerModifier * xpMod;
        fireTime = (int)((float)fireTime * (powerModifier * xpMod));
        performance = (int)((double)performance * ((double)(powerModifier * xpMod) * 0.5 + 1.0));
        Vec3d look = entity.func_70040_Z();
        double eyePos = (double)entity.func_70047_e() + entity.func_174813_aQ().field_72338_b;
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
            cooldown = 0;
            burnout = exhaustion = (float)0;
            chiCost = exhaustion;
        }
        if (bender.consumeChi(chiCost)) {
            abilityData.addBurnout(abilityData.getBurnOut() + burnout);
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_71020_j(exhaustion);
            }
            for (int i = 0; i < 24 + particleCount * 2; ++i) {
                EntityFlames flames;
                int bRandom;
                double x1 = entity.field_70165_t + look.field_72450_a * (double)i / 50.0 + world.field_73012_v.nextGaussian() * (double)accuracyMult + entity.field_70159_w;
                double y1 = eyePos - (double)0.4f + world.field_73012_v.nextGaussian() * (double)accuracyMult;
                double z1 = entity.field_70161_v + look.field_72449_c * (double)i / 50.0 + world.field_73012_v.nextGaussian() * (double)accuracyMult + entity.field_70179_y;
                int rRandom = fadeR < 100 ? AvatarUtils.getRandomNumberInRange(1, fadeR * 2) : AvatarUtils.getRandomNumberInRange(fadeR / 2, fadeR * 2);
                int gRandom = fadeG < 100 ? AvatarUtils.getRandomNumberInRange(1, fadeG * 2) : AvatarUtils.getRandomNumberInRange(fadeG / 2, fadeG * 2);
                int n = bRandom = fadeB < 100 ? AvatarUtils.getRandomNumberInRange(1, fadeB * 2) : AvatarUtils.getRandomNumberInRange(fadeB / 2, fadeB * 2);
                if (world.field_72995_K) {
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(x1, y1, z1).vel(look.field_72450_a * (double)mult + world.field_73012_v.nextGaussian() * (double)accuracyMult, look.field_72448_b * (double)mult + world.field_73012_v.nextGaussian() * (double)accuracyMult, look.field_72449_c * (double)mult + world.field_73012_v.nextGaussian() * (double)accuracyMult).element(new Firebending()).ability(strike).spawnEntity((Entity)entity).clr(r, g, b, 150).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(50, 140)).collide(true).collideParticles(true).scale(size * 0.75f).time(lifeTime + AvatarUtils.getRandomNumberInRange(1, 5)).spawn(world);
                    rRandom = fadeR < 100 ? AvatarUtils.getRandomNumberInRange(1, fadeR * 2) : AvatarUtils.getRandomNumberInRange(fadeR / 2, fadeR * 2);
                    gRandom = fadeG < 100 ? AvatarUtils.getRandomNumberInRange(1, fadeG * 2) : AvatarUtils.getRandomNumberInRange(fadeG / 2, fadeG * 2);
                    bRandom = fadeB < 100 ? AvatarUtils.getRandomNumberInRange(1, fadeB * 2) : AvatarUtils.getRandomNumberInRange(fadeB / 2, fadeB * 2);
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(x1, y1, z1).vel(look.field_72450_a * (double)mult + world.field_73012_v.nextGaussian() * (double)accuracyMult, look.field_72448_b * (double)mult + world.field_73012_v.nextGaussian() * (double)accuracyMult, look.field_72449_c * (double)mult + world.field_73012_v.nextGaussian() * (double)accuracyMult).element(new Firebending()).ability(strike).spawnEntity((Entity)entity).clr(255, 60 + AvatarUtils.getRandomNumberInRange(0, 60), 10, 150).collide(true).collideParticles(true).scale(size * 0.75f).time(lifeTime + AvatarUtils.getRandomNumberInRange(1, 5)).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(40, 140)).spawn(world);
                }
                if (strike.getBooleanProperty("setsFires", abilityData)) {
                    if (i % 12 != 0) continue;
                    flames = new EntityFlames(world);
                    flames.setOwner(entity);
                    flames.setDynamicSpreadingCollision(false);
                    flames.setAbility(strike);
                    flames.setTier(strike.getCurrentTier(abilityData));
                    flames.setXp(xp);
                    flames.setLifeTime((int)((double)lifeTime * 0.785) + AvatarUtils.getRandomNumberInRange(0, 4));
                    flames.setTrailingFires(strike.getBooleanProperty("setsFires", abilityData) && world.field_73012_v.nextBoolean());
                    flames.setFires(strike.getBooleanProperty("setsFires", abilityData) && world.field_73012_v.nextBoolean());
                    flames.setDamage(damage);
                    flames.setSmelts(strike.getBooleanProperty("smelts", abilityData));
                    flames.setFireTime(fireTime);
                    flames.setBehaviour(new FlameStrikeBehaviour());
                    flames.setPerformanceAmount(performance);
                    flames.setRGB(r, g, b);
                    flames.setFade(fadeR, fadeG, fadeB);
                    flames.setElement(new Firebending());
                    flames.setTier(strike.getCurrentTier(abilityData));
                    flames.func_70107_b(x1, y1, z1);
                    flames.setDamageSource("avatar_Fire_flameStrike");
                    flames.setChiHit(strike.getProperty("chiOnHit", abilityData).floatValue());
                    flames.setVelocity(new Vec3d(look.field_72450_a * (double)mult + world.field_73012_v.nextGaussian() * (double)accuracyMult + entity.field_70159_w, look.field_72448_b * (double)mult + world.field_73012_v.nextGaussian() * (double)accuracyMult, look.field_72449_c * (double)mult + world.field_73012_v.nextGaussian() * (double)accuracyMult + entity.field_70179_y));
                    flames.setEntitySize(size / 4.0f);
                    if (world.field_72995_K) continue;
                    world.func_72838_d((Entity)flames);
                    continue;
                }
                if (i % 3 != 0) continue;
                flames = new EntityFlames(world);
                flames.setOwner(entity);
                flames.setDynamicSpreadingCollision(false);
                flames.setAbility(strike);
                flames.setTier(strike.getCurrentTier(abilityData));
                flames.setXp(xp);
                flames.setLifeTime((int)((double)lifeTime * 0.785) + AvatarUtils.getRandomNumberInRange(0, 4));
                flames.setDamage(damage);
                flames.setSmelts(strike.getBooleanProperty("smelts", abilityData));
                flames.setFireTime(fireTime);
                flames.setBehaviour(new FlameStrikeBehaviour());
                flames.setPerformanceAmount(performance);
                flames.setRGB(r, g, b);
                flames.setFade(fadeR, fadeG, fadeB);
                flames.setElement(new Firebending());
                flames.setTier(strike.getCurrentTier(abilityData));
                flames.func_70107_b(x1, y1, z1);
                flames.setDamageSource("avatar_Fire_flameStrike");
                flames.setChiHit(strike.getProperty("chiOnHit", abilityData).floatValue());
                flames.setVelocity(new Vec3d(look.field_72450_a * (double)mult + world.field_73012_v.nextGaussian() * (double)accuracyMult + entity.field_70159_w, look.field_72448_b * (double)mult + world.field_73012_v.nextGaussian() * (double)accuracyMult, look.field_72449_c * (double)mult + world.field_73012_v.nextGaussian() * (double)accuracyMult + entity.field_70179_y));
                flames.setEntitySize(size / 8.0f);
                if (world.field_72995_K) continue;
                world.func_72838_d((Entity)flames);
            }
            if (this.hand == EnumHand.OFF_HAND) {
                entity.func_184609_a(this.hand);
            }
            abilityData.setUseNumber(abilityData.getUseNumber() + 1);
            world.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187557_bK, SoundCategory.PLAYERS, 1.0f + Math.max((float)abilityData.getLevel() * 0.5f, 0.0f), 1.25f * world.field_73012_v.nextFloat(), false);
            if (abilityData.getUseNumber() >= strike.getProperty("numberOfStrikes", abilityData).intValue()) {
                abilityData.setAbilityCooldown(cooldown);
                abilityData.setRegenBurnout(true);
                abilityData.setUseNumber(0);
                ctx.getData().removeTickHandler(TickHandlerController.FLAME_STRIKE_HANDLER, ctx);
                return true;
            }
            if (ctx.getData().hasTickHandler(TickHandlerController.FLAME_STRIKE_HANDLER)) {
                ctx.getData().addStatusControl(this.hand == EnumHand.MAIN_HAND ? StatusControlController.FLAME_STRIKE_OFF : StatusControlController.FLAME_STRIKE_MAIN);
            }
        } else {
            abilityData.setAbilityCooldown(cooldown);
            abilityData.setRegenBurnout(true);
        }
        return true;
    }

    public static class FlameStrikeBehaviour
    extends OffensiveBehaviour {
        public OffensiveBehaviour onUpdate(EntityOffensive entity) {
            if (entity.getOwner() != null) {
                entity.field_70159_w *= 0.95;
                entity.field_70181_x *= 0.95;
                entity.field_70179_y *= 0.95;
                if (entity.field_70170_p.field_72995_K && entity.field_70173_aa > 1) {
                    int[] fade = entity.getFade();
                    int[] rgb = entity.getRGB();
                    for (double i = 0.0; i < (double)entity.field_70130_N; i += 0.1 * (double)entity.getAvgSize() * 4.0) {
                        int rRandom = fade[0] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[0] * 2) : AvatarUtils.getRandomNumberInRange(fade[0] / 2, fade[0] * 2);
                        int gRandom = fade[1] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[1] * 2) : AvatarUtils.getRandomNumberInRange(fade[1] / 2, fade[1] * 2);
                        int bRandom = fade[2] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[2] * 2) : AvatarUtils.getRandomNumberInRange(fade[2] / 2, fade[2] * 2);
                        Random random = new Random();
                        Vec3d box = AvatarEntityUtils.getMiddleOfEntity(entity);
                        AxisAlignedBB boundingBox = entity.func_174813_aQ();
                        double spawnX = box.field_72450_a + random.nextDouble() * 1.5 * (boundingBox.field_72336_d - boundingBox.field_72340_a);
                        double spawnY = box.field_72448_b + random.nextDouble() * 1.5 * (boundingBox.field_72337_e - boundingBox.field_72338_b);
                        double spawnZ = box.field_72449_c + random.nextDouble() * 1.5 * (boundingBox.field_72334_f - boundingBox.field_72339_c);
                        ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(entity.field_70170_p.field_73012_v.nextGaussian() / 30.0, entity.field_70170_p.field_73012_v.nextGaussian() / 30.0, entity.field_70170_p.field_73012_v.nextGaussian() / 30.0).time(5 + AvatarUtils.getRandomNumberInRange(0, 2)).clr(rgb[0], rgb[1], rgb[2]).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(100, 175)).scale(entity.getAvgSize() * 2.0f).element(entity.getElement()).ability(entity.getAbility()).spawnEntity((Entity)entity.getOwner()).collide(true).collideParticles(true).spawn(entity.field_70170_p);
                        ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(entity.field_70170_p.field_73012_v.nextGaussian() / 30.0, entity.field_70170_p.field_73012_v.nextGaussian() / 30.0, entity.field_70170_p.field_73012_v.nextGaussian() / 30.0).time(5 + AvatarUtils.getRandomNumberInRange(0, 2)).clr(rgb[0], rgb[1], rgb[2]).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(100, 175)).scale(entity.getAvgSize() * 2.0f).element(entity.getElement()).ability(entity.getAbility()).spawnEntity((Entity)entity.getOwner()).collide(true).collideParticles(true).spawn(entity.field_70170_p);
                        ParticleBuilder.create(ParticleBuilder.Type.FIRE).pos(spawnX, spawnY, spawnZ).vel(entity.field_70170_p.field_73012_v.nextGaussian() / 50.0, entity.field_70170_p.field_73012_v.nextGaussian() / 50.0, entity.field_70170_p.field_73012_v.nextGaussian() / 50.0).time(5 + AvatarUtils.getRandomNumberInRange(0, 2)).scale(entity.getAvgSize() / 2.0f).element(entity.getElement()).ability(entity.getAbility()).spawnEntity((Entity)entity.getOwner()).collide(true).collideParticles(true).spawn(entity.field_70170_p);
                    }
                }
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

