/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire.statctrls;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.fire.AbilityFireball;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityFireball;
import com.crowsofwar.avatar.entity.data.FireballBehavior;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class StatCtrlThrowFireball
extends StatusControl {
    public StatCtrlThrowFireball() {
        super(10, AvatarControl.CONTROL_LEFT_CLICK_DOWN, StatusControl.CrosshairPosition.LEFT_OF_CROSSHAIR);
    }

    @Override
    public boolean execute(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        World world = ctx.getWorld();
        AbilityFireball ability = (AbilityFireball)Abilities.get("fireball");
        AbilityData abilityData = ctx.getData().getAbilityData(new AbilityFireball());
        EntityFireball fireball = AvatarEntity.lookupControlledEntity(world, EntityFireball.class, entity);
        List fireballs = world.func_72872_a(EntityFireball.class, entity.func_174813_aQ().func_72314_b(3.5, 3.0, 3.5));
        if (fireball != null) {
            Vector direction;
            assert (ability != null);
            float yaw = (float)Math.toRadians(entity.field_70177_z);
            float pitch = (float)Math.toRadians(entity.field_70125_A);
            double speedMult = (double)ability.getProperty("speed", abilityData).floatValue() * 3.5;
            float chi = ability.getChiCost(abilityData);
            int cooldown = ability.getCooldown(abilityData);
            float burnOut = ability.getBurnOut(abilityData);
            float exhaustion = ability.getExhaustion(abilityData);
            float size = ability.getProperty("size", abilityData).floatValue();
            float damage = ability.getProperty("damage", abilityData).floatValue();
            float maxDamage = ability.getProperty("maxDamage", abilityData).floatValue();
            float maxBurnout = ability.getProperty("maxBurnout", abilityData).floatValue();
            float maxExhaustion = ability.getProperty("maxExhaustion", abilityData).floatValue();
            speedMult *= abilityData.getDamageMult() * (double)abilityData.getXpModifier();
            damage = (float)((double)damage * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            maxDamage = (float)((double)maxDamage * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            size = (float)((double)size * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            float mult = fireball.getAvgSize() / size;
            maxBurnout = (float)((double)maxBurnout * ((2.0 - abilityData.getDamageMult()) * (double)abilityData.getXpModifier()));
            maxExhaustion = (float)((double)maxExhaustion * ((2.0 - abilityData.getDamageMult()) * (double)abilityData.getXpModifier()));
            exhaustion *= mult;
            exhaustion = Math.min(exhaustion, maxExhaustion);
            burnOut *= mult;
            burnOut = Math.min(burnOut, maxBurnout);
            damage *= mult;
            damage = Math.min(damage, maxDamage);
            Vec3d look = entity.func_70040_Z();
            Vec3d pos = entity.func_174824_e(1.0f);
            RayTraceResult r = Raytrace.rayTrace(world, pos, look.func_186678_a(75.0).func_178787_e(pos), 0.0f, false, true, false, Entity.class, e -> e instanceof EntityFireball || e == entity);
            if (r != null && r.field_72307_f != null) {
                Vec3d dir = r.field_72307_f.func_178788_d(fireball.func_174791_d()).func_72432_b();
                direction = new Vector(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
            } else {
                direction = Vector.toRectangular(yaw, pitch);
            }
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                cooldown = 0;
                burnOut = exhaustion = (float)0;
                chi = exhaustion;
            }
            if (Objects.requireNonNull(Bender.get(entity)).consumeChi(chi)) {
                fireball.setBehaviour(new FireballBehavior.Thrown());
                fireball.field_70125_A = entity.field_70125_A;
                fireball.field_70177_z = entity.field_70177_z;
                fireball.setDamage(damage);
                fireball.setVelocity(direction.times(speedMult));
                abilityData.setAbilityCooldown(cooldown);
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_71020_j(exhaustion);
                }
                abilityData.addBurnout(burnOut);
                fireballs = fireballs.stream().filter(fireball1 -> !(fireball1.getBehaviour() instanceof FireballBehavior.Thrown)).collect(Collectors.toList());
                if (fireballs.isEmpty()) {
                    abilityData.setRegenBurnout(true);
                }
            }
            world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187557_bK, SoundCategory.HOSTILE, 4.0f, 0.8f);
        }
        return true;
    }
}

