/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire.tickhandlers;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.fire.AbilityFlameGlide;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.EntityShockwave;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.TickHandler;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;

public class FlameGlideHandler
extends TickHandler {
    public FlameGlideHandler(int id) {
        super(id);
    }

    @Override
    public boolean tick(BendingContext ctx) {
        EntityLivingBase target = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        World world = ctx.getWorld();
        AbilityData data = ctx.getData().getAbilityData(new AbilityFlameGlide());
        AbilityFlameGlide jump = (AbilityFlameGlide)Abilities.get(new AbilityFlameGlide().getName());
        Vector pos = Vector.getEntityPos((Entity)target).minusY(0.05);
        if (world.field_72995_K && jump != null) {
            double minY = target.func_174813_aQ().field_72338_b;
            pos = pos.plus(Vector.getVelocity((Entity)target).times(0.1));
            pos = pos.withY(Math.max(pos.y(), minY));
            float size = jump.getProperty("size", data).floatValue() / 2.0f;
            int r = jump.getProperty("fireR", data).intValue();
            int g = jump.getProperty("fireG", data).intValue();
            int b = jump.getProperty("fireB", data).intValue();
            int fadeR = jump.getProperty("fadeR", data).intValue();
            int fadeG = jump.getProperty("fadeG", data).intValue();
            int fadeB = jump.getProperty("fadeB", data).intValue();
            size = (float)((double)size * (data.getDamageMult() * (double)data.getXpModifier()));
            for (int i = 0; i < 8 + AvatarUtils.getRandomNumberInRange(2, 4); ++i) {
                int rRandom = fadeR < 100 ? AvatarUtils.getRandomNumberInRange(0, fadeR * 2) : AvatarUtils.getRandomNumberInRange(fadeR / 2, fadeR * 2);
                int gRandom = fadeG < 100 ? AvatarUtils.getRandomNumberInRange(0, fadeG * 2) : AvatarUtils.getRandomNumberInRange(fadeG / 2, fadeG * 2);
                int bRandom = fadeB < 100 ? AvatarUtils.getRandomNumberInRange(0, fadeB * 2) : AvatarUtils.getRandomNumberInRange(fadeB / 2, fadeB * 2);
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).clr(r, g, b, 215 + AvatarUtils.getRandomNumberInRange(0, 40)).fade(rRandom, gRandom, bRandom, 160 + AvatarUtils.getRandomNumberInRange(0, 40)).pos(pos.toMinecraft()).vel(world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0).scale(size).time(6 + AvatarUtils.getRandomNumberInRange(0, 6)).element(new Firebending()).collide(true).ability(jump).spawnEntity((Entity)target).spawn(world);
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).clr(r, g * 4, b, 215 + AvatarUtils.getRandomNumberInRange(0, 40)).fade(rRandom, gRandom * 4, bRandom, 160 + AvatarUtils.getRandomNumberInRange(0, 40)).pos(pos.toMinecraft()).vel(world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0).scale(size).time(6 + AvatarUtils.getRandomNumberInRange(0, 6)).element(new Firebending()).collide(true).ability(jump).spawnEntity((Entity)target).spawn(world);
            }
        }
        int duration = 40;
        if (jump != null) {
            duration = jump.getProperty("duration", data).intValue();
            duration = (int)((double)duration * (data.getDamageMult() * (double)data.getXpModifier()));
        }
        if (jump != null && ctx.getData().getTickHandlerDuration(this) < duration && bender.consumeChi(jump.getChiCost(data) / 20.0f)) {
            double targetSpeed = jump.getProperty("speed", data).floatValue() / 4.0f;
            targetSpeed *= data.getDamageMult() * (double)data.getXpModifier();
            if (target.field_191988_bg != 0.0f) {
                targetSpeed = target.field_191988_bg < 0.0f ? (targetSpeed /= 2.0) : (targetSpeed *= 1.3);
            }
            double posY = target.field_70122_E ? target.func_174813_aQ().field_72338_b + 0.25 : target.func_174813_aQ().field_72338_b;
            target.func_70107_b(target.field_70165_t, posY, target.field_70161_v);
            Vector currentVelocity = new Vector(target.field_70159_w, target.field_70181_x, target.field_70179_y);
            Vector targetVelocity = Vector.toRectangular(Math.toRadians(target.field_70177_z), 0.0).times(targetSpeed);
            double targetWeight = 0.1;
            currentVelocity = currentVelocity.times(1.0 - targetWeight);
            targetVelocity = targetVelocity.times(targetWeight);
            double targetSpeedWeight = 0.2;
            double speed = currentVelocity.magnitude() * (1.0 - targetSpeedWeight) + targetSpeed * targetSpeedWeight;
            Vector newVelocity = currentVelocity.plus(targetVelocity).normalize().times(speed);
            Vector playerMovement = Vector.toRectangular(Math.toRadians(target.field_70177_z - 90.0f), Math.toRadians(target.field_70125_A)).times((double)target.field_70702_br * 0.02);
            newVelocity = newVelocity.plus(playerMovement);
            target.field_70159_w = newVelocity.x();
            target.field_70181_x = target.field_70122_E ? (target.field_70181_x += 0.1) : (target.field_70181_x += Math.max(target.func_70040_Z().func_186678_a((double)(speed / 5.0)).field_72448_b * 2.0, 0.05));
            target.field_70179_y = newVelocity.z();
            target.field_70181_x *= 0.5;
            if (!target.field_70122_E) {
                target.field_70160_al = true;
            }
            AvatarUtils.afterVelocityAdded((Entity)target);
            if (target instanceof EntityBender || target instanceof EntityPlayer && !((EntityPlayer)target).func_184812_l_()) {
                data.addBurnout(jump.getBurnOut(data) / 20.0f);
            }
            if (target instanceof EntityPlayer) {
                ((EntityPlayer)target).func_71020_j(jump.getExhaustion(data) / 20.0f);
            }
        }
        return target.func_70090_H() || target.func_70093_af() || bender.isFlying() || duration <= ctx.getData().getTickHandlerDuration(this);
    }

    @Override
    public void onRemoved(BendingContext ctx) {
        super.onRemoved(ctx);
        World world = ctx.getWorld();
        EntityLivingBase entity = ctx.getBenderEntity();
        AbilityData abilityData = ctx.getData().getAbilityData("flame_glide");
        AbilityFlameGlide jump = (AbilityFlameGlide)Abilities.get("flame_glide");
        if (jump != null && jump.getBooleanProperty("stopShockwave", abilityData)) {
            float speed = jump.getProperty("speed", abilityData).floatValue() / 5.0f;
            float size = jump.getProperty("size", abilityData).floatValue() * 1.25f;
            int lifetime = (int)(speed / size * 10.0f) / 2;
            float knockback = jump.getProperty("knockback", abilityData).floatValue();
            float damage = jump.getProperty("damage", abilityData).floatValue();
            int fireTime = jump.getProperty("fireTime", abilityData).intValue();
            int performance = jump.getProperty("performanceAmount", abilityData).intValue() / 10;
            float chiHit = jump.getProperty("chiOnHit", abilityData).floatValue() / 4.0f;
            int r = jump.getProperty("fireR", abilityData).intValue();
            int g = jump.getProperty("fireG", abilityData).intValue();
            int b = jump.getProperty("fireB", abilityData).intValue();
            int fadeR = jump.getProperty("fadeR", abilityData).intValue();
            int fadeG = jump.getProperty("fadeG", abilityData).intValue();
            int fadeB = jump.getProperty("fadeB", abilityData).intValue();
            speed = (float)((double)speed * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            size = (float)((double)size * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            lifetime = (int)((double)lifetime * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            knockback = (float)((double)knockback * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            damage = (float)((double)damage * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            fireTime = (int)((double)fireTime * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            performance = (int)((double)performance * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            chiHit = (float)((double)chiHit * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            EntityShockwave wave = new EntityShockwave(world);
            wave.setOwner(entity);
            wave.setDamageSource("avatar_Fire_shockwave");
            wave.setPosition(AvatarEntityUtils.getBottomMiddleOfEntity((Entity)entity).func_72441_c(0.0, 0.5, 0.0));
            wave.setFireTime(fireTime);
            wave.setEntitySize(size / 5.0f);
            wave.setElement(new Firebending());
            wave.setAbility(jump);
            wave.setDamage(damage);
            wave.setOwner(entity);
            wave.setSphere(false);
            wave.setSpeed(speed);
            wave.setRange(size * 1.5f);
            wave.setLifeTime(lifetime);
            wave.setChiHit(chiHit);
            wave.setPerformanceAmount(performance);
            wave.setPush(knockback);
            wave.setBehaviour(new FireJumpShockwave());
            wave.setParticleSpeed(speed / 45.0f);
            wave.setParticleAmount(20);
            wave.setRGB(r, g, b);
            wave.setFade(fadeR, fadeG, fadeB);
            wave.setRenderNormal(false);
            wave.setParticleWaves(lifetime * 2);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)wave);
            }
        }
        if (jump != null) {
            abilityData.setAbilityCooldown(jump.getCooldown(abilityData));
        }
    }

    public static class FireJumpShockwave
    extends OffensiveBehaviour {
        public OffensiveBehaviour onUpdate(EntityOffensive entity) {
            if (entity instanceof EntityShockwave && entity.field_70170_p.field_72995_K) {
                World world = entity.field_70170_p;
                if (entity.getOwner() != null) {
                    EntityLivingBase owner = entity.getOwner();
                    if (entity.field_70173_aa <= ((EntityShockwave)entity).getParticleWaves()) {
                        int[] fade = entity.getFade();
                        int[] rgb = entity.getRGB();
                        for (double angle = 0.0; angle < Math.PI * 2; angle += Math.PI / (((EntityShockwave)entity).getRange() * (double)((EntityShockwave)entity).getParticleAmount()) * (double)entity.field_70173_aa) {
                            int rRandom = fade[0] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[0] * 2) : AvatarUtils.getRandomNumberInRange(fade[0] / 2, fade[0] * 2);
                            int gRandom = fade[1] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[1] * 2) : AvatarUtils.getRandomNumberInRange(fade[1] / 2, fade[1] * 2);
                            int bRandom = fade[2] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[2] * 2) : AvatarUtils.getRandomNumberInRange(fade[2] / 2, fade[2] * 2);
                            double x2 = entity.field_70165_t + (double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() * Math.sin(angle);
                            double y2 = entity.field_70163_u;
                            double z2 = entity.field_70161_v + (double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() * Math.cos(angle);
                            Vector speed = new Vector((double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() * Math.sin(angle) * (entity.getParticleSpeed() * 10.0), entity.getParticleSpeed() / 2.0, (double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() * Math.cos(angle) * (entity.getParticleSpeed() * 10.0));
                            speed = speed.plus(world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0);
                            int time = 10;
                            time = Math.max(time, (entity.getLifeTime() - ((EntityShockwave)entity).getParticleWaves()) * 2);
                            ParticleBuilder.create(ParticleBuilder.Type.FLASH).element(new Firebending()).vel(speed.toMinecraft()).spawnEntity((Entity)owner).collide(true).collideParticles(true).clr(rgb[0], rgb[1], rgb[2], 180 + AvatarUtils.getRandomNumberInRange(0, 40)).fade(rRandom, gRandom, bRandom, 160 + AvatarUtils.getRandomNumberInRange(0, 40)).pos(x2, y2, z2).scale(entity.getAvgSize() * 2.0f).time(time + AvatarUtils.getRandomNumberInRange(0, 2)).spawn(world);
                            ParticleBuilder.create(ParticleBuilder.Type.FLASH).element(new Firebending()).vel(speed.toMinecraft()).spawnEntity((Entity)owner).collide(true).collideParticles(true).clr(rgb[0], rgb[1] * 8, rgb[2] * 4, 180 + AvatarUtils.getRandomNumberInRange(0, 40)).fade(rRandom, gRandom * 2, bRandom, 160 + AvatarUtils.getRandomNumberInRange(0, 40)).pos(x2, y2, z2).scale(entity.getAvgSize() * 2.0f).time(time + AvatarUtils.getRandomNumberInRange(0, 2)).spawn(world);
                        }
                    }
                }
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

