/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire.tickhandlers;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.fire.AbilityFlameStrike;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.PlayerViewRegistry;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.TickHandler;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class FlameStrikeHandler
extends TickHandler {
    public FlameStrikeHandler(int id) {
        super(id);
    }

    @Override
    public boolean tick(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        World world = ctx.getWorld();
        AbilityData abilityData = AbilityData.get(entity, "flame_strike");
        AbilityFlameStrike strike = (AbilityFlameStrike)Abilities.get(new AbilityFlameStrike().getName());
        if (strike != null && abilityData != null) {
            int usage = strike.getProperty("numberOfStrikes", abilityData).intValue();
            int particleCount = 1;
            int level = abilityData.getLevel();
            float particleSize = 0.7f;
            int r = strike.getProperty("fireR", abilityData).intValue();
            int g = strike.getProperty("fireG", abilityData).intValue();
            int b = strike.getProperty("fireB", abilityData).intValue();
            int fadeR = strike.getProperty("fadeR", abilityData).intValue();
            int fadeG = strike.getProperty("fadeG", abilityData).intValue();
            int fadeB = strike.getProperty("fadeB", abilityData).intValue();
            if (level == 1 || level == 2) {
                particleCount = 2;
            }
            if (level == 1) {
                particleSize = 0.8f;
            }
            if (level == 2) {
                particleSize = 0.875f;
            }
            if (abilityData.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
                particleCount = 3;
                usage = 5;
                particleSize = 0.825f;
            }
            if (abilityData.isMasterPath(AbilityData.AbilityTreePath.SECOND)) {
                particleCount = 2;
                usage = 3;
                particleSize = 1.0f;
            }
            particleSize = (float)((double)particleSize * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            if (data.hasStatusControl(StatusControlController.FLAME_STRIKE_MAIN) || data.hasStatusControl(StatusControlController.FLAME_STRIKE_OFF)) {
                Vec3d rightSide;
                Vec3d height;
                if (entity instanceof EntityPlayer) {
                    if (!(AvatarMod.realFirstPersonRender2Compat || PlayerViewRegistry.getPlayerViewMode(entity.func_110124_au()) < 2 && PlayerViewRegistry.getPlayerViewMode(entity.func_110124_au()) > -1)) {
                        height = entity.func_174791_d().func_72441_c(0.0, 1.5, 0.0);
                        height = height.func_178787_e(entity.func_70040_Z().func_186678_a(0.8));
                        rightSide = entity.func_184591_cq() == EnumHandSide.RIGHT && data.hasStatusControl(StatusControlController.FLAME_STRIKE_MAIN) || entity.func_184591_cq() == EnumHandSide.LEFT && data.hasStatusControl(StatusControlController.FLAME_STRIKE_OFF) ? Vector.toRectangular(Math.toRadians(entity.field_70177_z + 90.0f), 0.0).times(0.5).withY(0.0).toMinecraft() : Vector.toRectangular(Math.toRadians(entity.field_70177_z - 90.0f), 0.0).times(0.5).withY(0.0).toMinecraft();
                    } else {
                        height = entity.func_174791_d().func_72441_c(0.0, 0.84, 0.0);
                        rightSide = entity.func_184591_cq() == EnumHandSide.RIGHT && data.hasStatusControl(StatusControlController.FLAME_STRIKE_MAIN) || entity.func_184591_cq() == EnumHandSide.LEFT && data.hasStatusControl(StatusControlController.FLAME_STRIKE_OFF) ? Vector.toRectangular(Math.toRadians(entity.field_70761_aq + 90.0f), 0.0).times(0.385).withY(0.0).toMinecraft() : Vector.toRectangular(Math.toRadians(entity.field_70761_aq - 90.0f), 0.0).times(0.385).withY(0.0).toMinecraft();
                    }
                } else {
                    height = entity.func_174791_d().func_72441_c(0.0, 0.84, 0.0);
                    rightSide = entity.func_184591_cq() == EnumHandSide.RIGHT && data.hasStatusControl(StatusControlController.FLAME_STRIKE_MAIN) || entity.func_184591_cq() == EnumHandSide.LEFT && data.hasStatusControl(StatusControlController.FLAME_STRIKE_OFF) ? Vector.toRectangular(Math.toRadians(entity.field_70761_aq + 90.0f), 0.0).times(0.385).withY(0.0).toMinecraft() : Vector.toRectangular(Math.toRadians(entity.field_70761_aq - 90.0f), 0.0).times(0.385).withY(0.0).toMinecraft();
                }
                rightSide = rightSide.func_178787_e(height);
                if (world.field_72995_K) {
                    for (int i = 0; i < particleCount; ++i) {
                        int rRandom = fadeR < 100 ? AvatarUtils.getRandomNumberInRange(1, fadeR * 2) : AvatarUtils.getRandomNumberInRange(fadeR / 2, fadeR * 2);
                        int gRandom = fadeG < 100 ? AvatarUtils.getRandomNumberInRange(1, fadeG * 2) : AvatarUtils.getRandomNumberInRange(fadeG / 2, fadeG * 2);
                        int bRandom = fadeB < 100 ? AvatarUtils.getRandomNumberInRange(1, fadeB * 2) : AvatarUtils.getRandomNumberInRange(fadeB / 2, fadeB * 2);
                        ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(rightSide).time(6 + AvatarUtils.getRandomNumberInRange(0, 4)).vel(world.field_73012_v.nextGaussian() / 40.0, world.field_73012_v.nextDouble() / 40.0, world.field_73012_v.nextGaussian() / 40.0).clr(r, g, b).collide(true).scale(particleSize / 2.0f).element(new Firebending()).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(20, 100)).ability(strike).spawnEntity((Entity)entity).spawn(world);
                        ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(rightSide).time(6 + AvatarUtils.getRandomNumberInRange(0, 4)).vel(world.field_73012_v.nextGaussian() / 40.0, world.field_73012_v.nextDouble() / 40.0, world.field_73012_v.nextGaussian() / 40.0).clr(255, 60 + AvatarUtils.getRandomNumberInRange(0, 60), 10).collide(true).scale(particleSize / 2.0f).element(new Firebending()).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(20, 100)).ability(strike).spawnEntity((Entity)entity).spawn(world);
                    }
                }
            } else {
                return true;
            }
            if (usage - abilityData.getUseNumber() <= 0) {
                data.removeStatusControl(StatusControlController.FLAME_STRIKE_MAIN);
                data.removeStatusControl(StatusControlController.FLAME_STRIKE_OFF);
                return true;
            }
            if (data.getTickHandlerDuration(this) > 240) {
                data.removeStatusControl(StatusControlController.FLAME_STRIKE_MAIN);
                data.removeStatusControl(StatusControlController.FLAME_STRIKE_OFF);
                return true;
            }
        }
        return false;
    }

    @Override
    public void onRemoved(BendingContext ctx) {
        super.onRemoved(ctx);
        ctx.getData().getAbilityData("flame_strike").setUseNumber(0);
    }
}

