/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire.tickhandlers;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.fire.AbilityFlamethrower;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.config.ConfigClient;
import com.crowsofwar.avatar.entity.EntityFlames;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.damageutils.AvatarDamageSource;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.TickHandler;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class FlamethrowerUpdateTick
extends TickHandler {
    public static final UUID FLAMETHROWER_MOVEMENT_MODIFIER_ID = UUID.fromString("34877be6-6cf5-43f4-a8b3-aa12526651cf");

    public FlamethrowerUpdateTick(int id) {
        super(id);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean tick(BendingContext ctx) {
        float requiredChi;
        AbilityData abilityData;
        World world;
        EntityLivingBase entity;
        BendingData data;
        block11: {
            Vector start;
            Vector look;
            int fadeB;
            int fadeG;
            int fadeR;
            int b;
            int g;
            int r;
            int lifetime;
            float size;
            double speedMult;
            int flamesPerSecond;
            AbilityFlamethrower flamethrower;
            block12: {
                block10: {
                    boolean headInLiquid;
                    data = ctx.getData();
                    entity = ctx.getBenderEntity();
                    Bender bender = ctx.getBender();
                    world = ctx.getWorld();
                    abilityData = data.getAbilityData("flamethrower");
                    flamethrower = (AbilityFlamethrower)Abilities.get("flamethrower");
                    if (flamethrower == null) {
                        return false;
                    }
                    flamesPerSecond = Math.max(flamethrower.getProperty("particles", abilityData).intValue(), 1);
                    requiredChi = flamethrower.getProperty("chiCost", abilityData).floatValue() / 20.0f;
                    double powerFactor = 2.0 - abilityData.getDamageMult();
                    if (!bender.consumeChi(requiredChi = (float)((double)requiredChi * powerFactor))) {
                        abilityData.setRegenBurnout(true);
                        entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(FLAMETHROWER_MOVEMENT_MODIFIER_ID);
                        return true;
                    }
                    Vector eye = Vector.getEyePos((Entity)entity);
                    boolean isRaining = world.func_72896_J() && world.func_175678_i(entity.func_180425_c()) && world.func_180494_b(entity.func_180425_c()).func_76738_d();
                    boolean inWaterBlock = world.func_180495_p(entity.func_180425_c()) instanceof BlockLiquid || world.func_180495_p(entity.func_180425_c()).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(entity.func_180425_c()).func_177230_c() == Blocks.field_150358_i;
                    boolean bl = headInLiquid = world.func_180495_p(entity.func_180425_c().func_177984_a()) instanceof BlockLiquid || world.func_180495_p(entity.func_180425_c().func_177984_a()).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(entity.func_180425_c().func_177984_a()).func_177230_c() == Blocks.field_150358_i;
                    if (isRaining && flamethrower.getCurrentTier(abilityData) <= 3 || headInLiquid || inWaterBlock) break block10;
                    speedMult = flamethrower.getProperty("speed", abilityData).floatValue() * 3.0f;
                    double randomness = flamethrower.getProperty("randomness", abilityData).doubleValue();
                    size = flamethrower.getProperty("size", abilityData).floatValue();
                    int fireTime = flamethrower.getProperty("fireTime", abilityData).intValue();
                    float damage = flamethrower.getProperty("damage", abilityData).floatValue();
                    float performanceAmount = flamethrower.getProperty("performanceAmount", abilityData).floatValue();
                    float xp = flamethrower.getProperty("xpOnHit", abilityData).floatValue();
                    float chiHit = flamethrower.getProperty("chiOnHit", abilityData).floatValue();
                    lifetime = flamethrower.getProperty("lifeTime", abilityData).intValue();
                    float knockback = flamethrower.getProperty("knockback", abilityData).floatValue();
                    r = flamethrower.getProperty("fireR", abilityData).intValue();
                    g = flamethrower.getProperty("fireG", abilityData).intValue();
                    b = flamethrower.getProperty("fireB", abilityData).intValue();
                    fadeR = flamethrower.getProperty("fadeR", abilityData).intValue();
                    fadeG = flamethrower.getProperty("fadeG", abilityData).intValue();
                    fadeB = flamethrower.getProperty("fadeB", abilityData).intValue();
                    size = (float)((double)size * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
                    damage = (float)((double)damage * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
                    fireTime = (int)((double)fireTime * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
                    speedMult *= abilityData.getDamageMult() * (double)abilityData.getXpModifier();
                    randomness -= bender.calcPowerRating(Firebending.ID) / 100.0;
                    randomness = (randomness *= 0.5 / abilityData.getPowerRatingMult() * (double)abilityData.getXpModifier()) < 0.0 ? 0.0 : randomness;
                    lifetime = (int)((double)lifetime * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
                    knockback = (float)((double)knockback * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
                    double yawRandom = (double)entity.field_70177_z + (Math.random() * 2.0 - 1.0) * randomness;
                    double pitchRandom = (double)entity.field_70125_A + (Math.random() * 2.0 - 1.0) * randomness;
                    double range = Math.min(Math.max(1.0 - speedMult / 25.0, (double)0.1f), 0.25);
                    look = Vector.toRectangular(Math.toRadians(yawRandom), Math.toRadians(pitchRandom));
                    start = look.times(range).plus(eye.minusY(0.45));
                    if (entity.field_70173_aa % 2 == 0) {
                        EntityFlames flames = new EntityFlames(world);
                        flames.setPosition(start);
                        flames.setOwner(entity);
                        flames.setDynamicSpreadingCollision(true);
                        flames.setAbility(new AbilityFlamethrower());
                        flames.setDamageSource(abilityData.isDynamicMasterLevel(AbilityData.AbilityTreePath.FIRST) ? AvatarDamageSource.FIRE.func_76355_l() + "_dragonFire" : AvatarDamageSource.FIRE.func_76355_l() + "_flamethrower");
                        flames.setTier(flamethrower.getCurrentTier(abilityData));
                        flames.setXp(flamethrower.getProperty("xpOnHit", abilityData).floatValue());
                        flames.setVelocity(look.times(speedMult / 29.5).toMinecraft());
                        flames.setLifeTime(lifetime + AvatarUtils.getRandomNumberInRange(0, 4));
                        flames.setTrailingFires(flamethrower.getBooleanProperty("setsFires", abilityData));
                        flames.setFires(flamethrower.getBooleanProperty("setsFires", abilityData));
                        flames.setFireTime(fireTime);
                        flames.setChiHit(chiHit);
                        flames.setXp(xp);
                        flames.setDamage(damage);
                        flames.setPush(knockback);
                        flames.setRGB(r, g, b);
                        flames.setFade(fadeR, fadeG, fadeB);
                        flames.setSmelts(flamethrower.getBooleanProperty("smelts", abilityData));
                        flames.setFireTime(fireTime);
                        flames.setPerformanceAmount((int)performanceAmount);
                        flames.setElement(new Firebending());
                        flames.setRedirectable(true);
                        flames.setBehaviour(new FlamethrowerBehaviour());
                        flames.setChiHit(flamethrower.getProperty("chiOnHit", abilityData).floatValue());
                        flames.setEntitySize(size / 4.0f);
                        if (!world.field_72995_K) {
                            world.func_72838_d((Entity)flames);
                        }
                    }
                    if (!world.field_72995_K || flamethrower.getCurrentTier(abilityData) >= 4 && isRaining) break block11;
                    speedMult /= 29.5;
                    break block12;
                }
                if (world.field_72995_K) {
                    for (int i = 0; i < 30; ++i) {
                        ParticleBuilder.create(ParticleBuilder.Type.SNOW).collide(true).time(12 + AvatarUtils.getRandomNumberInRange(0, 3)).vel(world.field_73012_v.nextGaussian() / 40.0, world.field_73012_v.nextGaussian() / 40.0, world.field_73012_v.nextGaussian() / 40.0).scale(0.125f + flamethrower.getProperty("size", abilityData).floatValue() / 2.0f).pos(Vector.getEyePos((Entity)entity).plus(Vector.getLookRectangular((Entity)entity)).toMinecraft()).clr(1.0f, 1.0f, 1.0f, 0.85f).spawn(world);
                    }
                }
                entity.field_70170_p.func_184133_a(null, new BlockPos((Entity)entity), SoundEvents.field_187646_bt, entity.func_184176_by(), 1.0f, 0.8f + world.field_73012_v.nextFloat() / 10.0f);
                if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(FLAMETHROWER_MOVEMENT_MODIFIER_ID) == null) return true;
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(FLAMETHROWER_MOVEMENT_MODIFIER_ID);
                return true;
            }
            for (int i = 0; i < flamesPerSecond; ++i) {
                int rRandom = fadeR < 100 ? AvatarUtils.getRandomNumberInRange(1, fadeR * 2) : AvatarUtils.getRandomNumberInRange(fadeR / 2, fadeR * 2);
                int gRandom = fadeG < 100 ? AvatarUtils.getRandomNumberInRange(1, fadeG * 2) : AvatarUtils.getRandomNumberInRange(fadeG / 2, fadeG * 2);
                int bRandom = fadeB < 100 ? AvatarUtils.getRandomNumberInRange(1, fadeB * 2) : AvatarUtils.getRandomNumberInRange(fadeB / 2, fadeB * 2);
                ConfigClient.CLIENT_CONFIG.fireRenderSettings.getClass();
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(start.toMinecraft()).time(lifetime + AvatarUtils.getRandomNumberInRange(4, 8)).vel(look.times(speedMult).toMinecraft()).clr(r, g, b, 180).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(40, 100)).collide(true).collideParticles(true).spawnEntity((Entity)entity).scale(size * 1.5f).element(new Firebending()).ability(flamethrower).spawn(world);
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(start.toMinecraft()).time(lifetime + AvatarUtils.getRandomNumberInRange(4, 8)).vel(look.times(speedMult).toMinecraft()).clr(r, g + 15, b, 180).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(40, 100)).collide(true).collideParticles(true).spawnEntity((Entity)entity).scale(size * 1.5f).element(new Firebending()).ability(flamethrower).spawn(world);
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(start.toMinecraft()).time(lifetime + AvatarUtils.getRandomNumberInRange(4, 8)).vel(look.times(speedMult).toMinecraft()).clr(r, g + 60, b * 2, 180).fade(rRandom, gRandom + 60, bRandom * 2, AvatarUtils.getRandomNumberInRange(40, 100)).collide(true).collideParticles(true).spawnEntity((Entity)entity).scale(size * 1.5f).element(new Firebending()).ability(flamethrower).spawn(world);
            }
        }
        if (ctx.getData().getTickHandlerDuration(this) % 4 == 0) {
            world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187616_bj, SoundCategory.PLAYERS, 0.2f, 0.8f);
        }
        float movementModifier = 1.0f - Math.min(requiredChi * 12.5f, 0.7f);
        if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(FLAMETHROWER_MOVEMENT_MODIFIER_ID) == null) {
            this.applyMovementModifier(entity, movementModifier);
        }
        if (data.hasStatusControl(StatusControlController.STOP_FLAMETHROW)) {
            abilityData.setRegenBurnout(true);
        }
        if (data.hasStatusControl(StatusControlController.STOP_FLAMETHROW)) return false;
        return true;
    }

    private void applyMovementModifier(EntityLivingBase entity, float multiplier) {
        IAttributeInstance moveSpeed = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        moveSpeed.func_188479_b(FLAMETHROWER_MOVEMENT_MODIFIER_ID);
        moveSpeed.func_111121_a(new AttributeModifier(FLAMETHROWER_MOVEMENT_MODIFIER_ID, "Flamethrower Movement Modifier", (double)(multiplier - 1.0f), 1));
    }

    public static class FlamethrowerBehaviour
    extends OffensiveBehaviour {
        public OffensiveBehaviour onUpdate(EntityOffensive entity) {
            if (entity.getOwner() != null) {
                entity.field_70159_w *= 0.95;
                entity.field_70181_x *= 0.95;
                entity.field_70179_y *= 0.95;
                if (entity.field_70170_p.field_72995_K && entity.field_70173_aa > 1) {
                    int[] fade = entity.getFade();
                    int[] rgb = entity.getRGB();
                    int h = 0;
                    while (true) {
                        double d = h;
                        double d2 = entity.getOwner() instanceof EntityPlayer ? 1.0 : entity.velocity().magnitude() / 10.0;
                        if (!(d < Math.max(1.0, d2))) break;
                        for (double i = 0.0; i < (double)entity.field_70130_N; i += entity.getOwner() instanceof EntityPlayer ? (double)(entity.field_70130_N / 2.0f) : 0.25 * (double)entity.getAvgSize() * 2.0) {
                            float scale;
                            int rRandom = fade[0] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[0] * 2) : AvatarUtils.getRandomNumberInRange(fade[0] / 2, fade[0] * 2);
                            int gRandom = fade[1] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[1] * 2) : AvatarUtils.getRandomNumberInRange(fade[1] / 2, fade[1] * 2);
                            int bRandom = fade[2] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[2] * 2) : AvatarUtils.getRandomNumberInRange(fade[2] / 2, fade[2] * 2);
                            Random random = new Random();
                            Vec3d box = AvatarEntityUtils.getMiddleOfEntity(entity);
                            AxisAlignedBB boundingBox = entity.func_174813_aQ();
                            double spawnX = box.field_72450_a + random.nextDouble() * 0.125 * (boundingBox.field_72336_d - boundingBox.field_72340_a);
                            double spawnY = box.field_72448_b + random.nextDouble() * 0.125 * (boundingBox.field_72337_e - boundingBox.field_72338_b);
                            double spawnZ = box.field_72449_c + random.nextDouble() * 0.125 * (boundingBox.field_72334_f - boundingBox.field_72339_c);
                            int time = 10 - (int)(entity.velocity().magnitude() / 20.0) + AvatarUtils.getRandomNumberInRange(0, 2);
                            float f = scale = entity.getOwner() instanceof EntityBender ? 2.0f : 1.0f;
                            if (entity.getOwner() instanceof EntityPlayer) {
                                time = 4 - (int)(entity.velocity().magnitude() / 20.0) + AvatarUtils.getRandomNumberInRange(0, 2);
                            }
                            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(entity.field_70170_p.field_73012_v.nextGaussian() / 10.0 * (double)entity.getAvgSize(), entity.field_70170_p.field_73012_v.nextGaussian() / 10.0 * (double)entity.getAvgSize(), entity.field_70170_p.field_73012_v.nextGaussian() / 10.0 * (double)entity.getAvgSize()).time(time).clr(rgb[0], rgb[1], rgb[2]).scale(entity.getAvgSize() * scale).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(100, 175)).element(entity.getElement()).ability(entity.getAbility()).spawnEntity((Entity)entity.getOwner()).collide(true).collideParticles(entity.getOwner() instanceof EntityBender).spawn(entity.field_70170_p);
                            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(entity.field_70170_p.field_73012_v.nextGaussian() / 10.0 * (double)entity.getAvgSize(), entity.field_70170_p.field_73012_v.nextGaussian() / 10.0 * (double)entity.getAvgSize(), entity.field_70170_p.field_73012_v.nextGaussian() / 10.0 * (double)entity.getAvgSize()).time(time).clr(rgb[0], rgb[1], rgb[2]).scale(entity.getAvgSize() * scale).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(100, 175)).element(entity.getElement()).ability(entity.getAbility()).spawnEntity((Entity)entity.getOwner()).collide(true).collideParticles(entity.getOwner() instanceof EntityBender).spawn(entity.field_70170_p);
                            ParticleBuilder.create(ParticleBuilder.Type.FIRE).pos(spawnX, spawnY, spawnZ).vel(entity.field_70170_p.field_73012_v.nextGaussian() / 7.5 * (double)entity.getAvgSize(), entity.field_70170_p.field_73012_v.nextGaussian() / 7.5 * (double)entity.getAvgSize(), entity.field_70170_p.field_73012_v.nextGaussian() / 7.5 * (double)entity.getAvgSize()).time(time + 2).clr(rgb[0], rgb[1], rgb[2]).scale(entity.getAvgSize() / 1.25f * scale).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(100, 175)).element(entity.getElement()).ability(entity.getAbility()).spawnEntity((Entity)entity.getOwner()).collide(true).collideParticles(entity.getOwner() instanceof EntityBender).spawn(entity.field_70170_p);
                        }
                        ++h;
                    }
                }
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

