/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.fire.tickhandlers;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.fire.AbilityImmolate;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.client.particle.NetworkParticleSpawner;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.client.particle.ParticleSpawner;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.TickHandler;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class ImmolateParticleHandler
extends TickHandler {
    private final ParticleSpawner particles = new NetworkParticleSpawner();

    public ImmolateParticleHandler(int id) {
        super(id);
    }

    @Override
    public boolean tick(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        AbilityData aD = data.getAbilityData("immolate");
        World world = ctx.getWorld();
        AbilityImmolate immolate = (AbilityImmolate)Abilities.get("immolate");
        int duration = data.getTickHandlerDuration(this);
        float scale = 0.75f + (float)Math.max(0, aD.getLevel()) * 0.125f;
        assert (immolate != null);
        int immolateDuration = immolate.getProperty("duration", aD).intValue();
        int r = immolate.getProperty("fireR", aD).intValue();
        int g = immolate.getProperty("fireG", aD).intValue();
        int b = immolate.getProperty("fireB", aD).intValue();
        int fadeR = immolate.getProperty("fadeR", aD).intValue();
        int fadeG = immolate.getProperty("fadeG", aD).intValue();
        int fadeB = immolate.getProperty("fadeB", aD).intValue();
        scale *= (float)aD.getDamageMult() * aD.getXpModifier();
        if (world.field_72995_K) {
            for (int i = 0; i < 10 + Math.max(aD.getLevel(), 1) * 2; ++i) {
                int rRandom = fadeR < 100 ? AvatarUtils.getRandomNumberInRange(1, fadeR * 2) : AvatarUtils.getRandomNumberInRange(fadeR / 2, fadeR * 2);
                int gRandom = fadeG < 100 ? AvatarUtils.getRandomNumberInRange(1, fadeG * 2) : AvatarUtils.getRandomNumberInRange(fadeG / 2, fadeG * 2);
                int bRandom = fadeB < 100 ? AvatarUtils.getRandomNumberInRange(1, fadeB * 2) : AvatarUtils.getRandomNumberInRange(fadeB / 2, fadeB * 2);
                double random = world.field_73012_v.nextGaussian();
                double radius = world.field_73012_v.nextDouble() * (double)0.2f * (double)Math.max(aD.getLevel(), 0);
                Vector location = Vector.toRectangular(Math.toRadians((double)(entity.field_70177_z + (float)(i * 30)) + random * 2.0), 0.0).times(radius).withY((double)entity.func_70047_e() - 0.7);
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(location.plus(Vector.getEntityPos((Entity)entity)).toMinecraft()).time(4 + AvatarUtils.getRandomNumberInRange(1, 4)).vel(world.field_73012_v.nextGaussian() / 40.0, world.field_73012_v.nextDouble() / 2.0, world.field_73012_v.nextGaussian() / 40.0).clr(r, g, b, 150).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(50, 140)).element(new Firebending()).scale(scale).spawn(world);
            }
        }
        return duration >= immolateDuration;
    }
}

