/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.ice;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.ice.Icebending;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityIceShield;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class AbilityIceBurst
extends Ability {
    public AbilityIceBurst() {
        super(Icebending.ID, "ice_burst");
    }

    @Override
    public void execute(AbilityContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        World world = ctx.getWorld();
        Bender bender = ctx.getBender();
        if (!bender.consumeChi(ConfigStats.STATS_CONFIG.chiIceShieldCreate)) {
            return;
        }
        if (data.hasStatusControl(StatusControlController.SHIELD_SHATTER)) {
            return;
        }
        EntityIceShield shield = new EntityIceShield(world);
        shield.func_82149_j((Entity)entity);
        shield.setOwner(entity);
        AbilityData abilityData = ctx.getAbilityData();
        double damageMult = abilityData.getLevel() >= 1 ? 1.25 : 1.0;
        damageMult *= ctx.getPowerRatingDamageMod();
        float[] shardPitchAngles = new float[]{-10.0f, 10.0f};
        boolean targetMobs = abilityData.isMasterPath(AbilityData.AbilityTreePath.FIRST);
        float health = abilityData.getLevel() >= 2 ? 12.0f : 8.0f;
        health += (float)ctx.getPowerRating() / 15.0f;
        if (abilityData.getLevel() >= 2) {
            shardPitchAngles = new float[]{-20.0f, 0.0f, 30.0f};
        }
        if (abilityData.isMasterPath(AbilityData.AbilityTreePath.SECOND)) {
            health = 18.0f;
        }
        shield.setDamageMult(damageMult);
        shield.setTargetMobs(targetMobs);
        shield.setPitchAngles(shardPitchAngles);
        shield.setHealth(health);
        shield.setMaxHealth(health);
        shield.setAbility(this);
        world.func_72838_d((Entity)shield);
        data.addStatusControl(StatusControlController.SHIELD_SHATTER);
        abilityData.addXp(ConfigSkills.SKILLS_CONFIG.iceShieldCreated);
    }

    @Override
    public boolean isOffensive() {
        return true;
    }

    @Override
    public boolean isUtility() {
        return true;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public int getBaseTier() {
        return 2;
    }

    @Override
    public int getBaseParentTier() {
        return 4;
    }
}

