/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.lightning;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.lightning.Lightningbending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityLightningSpawner;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class AbilityLightningRaze
extends Ability {
    public AbilityLightningRaze() {
        super(Lightningbending.ID, "lightning_raze");
    }

    @Override
    public void execute(AbilityContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        World world = ctx.getWorld();
        Bender bender = ctx.getBender();
        int ticks = ConfigStats.STATS_CONFIG.lightningRazeSettings.ticks;
        double speed = ConfigStats.STATS_CONFIG.lightningRazeSettings.speed;
        float chi = ConfigStats.STATS_CONFIG.chiLightningRaze;
        float frequency = ConfigStats.STATS_CONFIG.lightningRazeSettings.frequency;
        int bolts = ConfigStats.STATS_CONFIG.lightningRazeSettings.bolts;
        float accuracy = ConfigStats.STATS_CONFIG.lightningRazeSettings.accuracy;
        if (ctx.getLevel() >= 1) {
            ticks = ConfigStats.STATS_CONFIG.lightningRazeSettings.ticks * 2;
            frequency = ConfigStats.STATS_CONFIG.lightningRazeSettings.frequency * 0.8f;
            chi = ConfigStats.STATS_CONFIG.chiLightningRaze * 1.2f;
            speed = ConfigStats.STATS_CONFIG.lightningRazeSettings.speed * 1.4;
            bolts = ConfigStats.STATS_CONFIG.lightningRazeSettings.bolts * 2;
        }
        if (ctx.getLevel() >= 2) {
            speed = 9.0;
            frequency = 3.0f;
            chi = 7.0f;
            bolts = 3;
            accuracy = 0.75f;
        }
        if (ctx.isMasterLevel(AbilityData.AbilityTreePath.FIRST)) {
            frequency = 2.0f;
            bolts = 1;
            ticks = 40;
            speed = 20.0;
            chi = 7.0f;
            accuracy = 0.0f;
        }
        if (ctx.isMasterLevel(AbilityData.AbilityTreePath.SECOND)) {
            frequency = 4.0f;
            ticks = 60;
            speed = 3.0;
            chi = 8.0f;
            bolts = 5;
            accuracy = 2.0f;
        }
        if (bender.consumeChi(chi)) {
            Raytrace.Result hit = Raytrace.getTargetBlock(entity, 6.0);
            if (ctx.isMasterLevel(AbilityData.AbilityTreePath.FIRST)) {
                hit = Raytrace.getTargetBlock(entity, 8.0);
            }
            if (ctx.isMasterLevel(AbilityData.AbilityTreePath.SECOND)) {
                hit = Raytrace.getTargetBlock(entity, 20.0);
            }
            Vector look = Vector.toRectangular(Math.toRadians(entity.field_70177_z), 0.0);
            Vector playerPos = Vector.getEyePos((Entity)entity);
            Vector lookPos = playerPos.plus(Vector.getLookRectangular((Entity)entity).times(1.3));
            Vector hitAt = hit.getPosPrecise();
            EntityLightningSpawner boltSpawner = new EntityLightningSpawner(world);
            boltSpawner.setOwner(entity);
            if (hit.hitSomething()) {
                boltSpawner.func_70107_b(hitAt.x(), hitAt.y(), hitAt.z());
            } else {
                boltSpawner.setPosition(lookPos.withY(entity.field_70163_u));
            }
            boltSpawner.setVelocity(look.times(speed));
            boltSpawner.setSpeed(speed);
            boltSpawner.setAbility(this);
            boltSpawner.setDuration(ticks);
            boltSpawner.setLightningFrequency(frequency);
            boltSpawner.setPlayerControl(ctx.isMasterLevel(AbilityData.AbilityTreePath.SECOND));
            boltSpawner.setAmountofBolts(bolts);
            boltSpawner.setAccuracy(accuracy);
            world.func_72838_d((Entity)boltSpawner);
        }
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean isOffensive() {
        return true;
    }

    @Override
    public int getBaseTier() {
        return 3;
    }

    @Override
    public int getBaseParentTier() {
        return 5;
    }
}

