/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.lightning;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingAi;
import com.crowsofwar.avatar.bending.bending.lightning.AiLightningSpear;
import com.crowsofwar.avatar.bending.bending.lightning.Lightningbending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityLightningSpear;
import com.crowsofwar.avatar.entity.data.LightningSpearBehavior;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class AbilityLightningSpear
extends Ability {
    public AbilityLightningSpear() {
        super(Lightningbending.ID, "lightning_spear");
        this.requireRaytrace(-1.0, false);
    }

    @Override
    public void execute(AbilityContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        World world = ctx.getWorld();
        BendingData data = ctx.getData();
        AbilityData abilityData = ctx.getAbilityData();
        if (data.hasStatusControl(StatusControlController.THROW_LIGHTNINGSPEAR)) {
            return;
        }
        if (bender.consumeChi(ConfigStats.STATS_CONFIG.chiLightningSpear)) {
            double speedMult;
            Vector target;
            float size = 1.2f;
            float damage = 2.0f;
            if (abilityData.getLevel() >= 2) {
                damage = 8.0f;
            }
            if (ctx.getLevel() == 1) {
                size = 1.4f;
                damage = 3.0f;
            }
            if (ctx.getLevel() == 2) {
                size = 1.6f;
                damage = 4.0f;
            }
            if (ctx.isMasterLevel(AbilityData.AbilityTreePath.FIRST)) {
                size = 1.2f;
                damage = 6.0f;
            }
            if (ctx.isMasterLevel(AbilityData.AbilityTreePath.SECOND)) {
                size = 2.2f;
                damage = 5.0f;
            }
            damage = (float)((double)damage * ctx.getPowerRatingDamageMod());
            EntityLightningSpear spear = new EntityLightningSpear(world);
            spear.setEntitySize(size);
            if (ctx.isLookingAtBlock()) {
                target = ctx.getLookPos();
            } else {
                Vector playerPos = Vector.getEyePos((Entity)entity);
                target = playerPos.plus(Vector.getLookRectangular((Entity)entity).times(spear.getAvgSize()));
            }
            assert (target != null);
            spear.setPosition(target);
            spear.setOwner(entity);
            spear.setBehavior(new LightningSpearBehavior.PlayerControlled());
            spear.setDamage(damage);
            spear.field_70125_A = entity.field_70125_A;
            spear.field_70177_z = entity.field_70177_z;
            spear.setPiercing(abilityData.isMasterPath(AbilityData.AbilityTreePath.FIRST));
            spear.setAbility(this);
            spear.setDegreesPerSecond(400.0f);
            spear.setEntitySize(size / 8.0f);
            spear.setGroupAttack(abilityData.isMasterPath(AbilityData.AbilityTreePath.SECOND));
            double d = speedMult = abilityData.getLevel() >= 1 ? 55.0 : 45.0;
            if (abilityData.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
                speedMult = 80.0;
            }
            spear.setBehavior(new LightningSpearBehavior.Thrown());
            spear.setVelocity(Vector.getLookRectangular((Entity)entity).times(speedMult));
            Vector direction = spear.velocity().toSpherical();
            spear.field_70177_z = (float)Math.toDegrees(direction.y());
            spear.field_70125_A = (float)Math.toDegrees(direction.x());
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)spear);
            }
            data.addStatusControl(StatusControlController.THROW_LIGHTNINGSPEAR);
        }
    }

    @Override
    public boolean isOffensive() {
        return true;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public int getBaseParentTier() {
        return 3;
    }

    @Override
    public BendingAi getAi(EntityLiving entity, Bender bender) {
        return new AiLightningSpear(this, entity, bender);
    }
}

