/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.lightning;

import com.crowsofwar.avatar.bending.bending.lightning.AbilityLightningArc;
import com.crowsofwar.avatar.bending.bending.lightning.Lightningbending;
import com.crowsofwar.avatar.client.particle.AvatarParticles;
import com.crowsofwar.avatar.client.particle.NetworkParticleSpawner;
import com.crowsofwar.avatar.client.particle.ParticleSpawner;
import com.crowsofwar.avatar.entity.EntityLightningArc;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.TickHandler;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class LightningChargeHandler
extends TickHandler {
    private static final UUID MOVEMENT_MODIFIER_ID = UUID.fromString("dfb6235c-82b6-407e-beaf-a48045735a82");
    private ParticleSpawner particleSpawner = new NetworkParticleSpawner();

    LightningChargeHandler(int id) {
        super(id);
    }

    @Nullable
    protected abstract AbilityData getLightningData(BendingContext var1);

    @Override
    public boolean tick(BendingContext ctx) {
        World world = ctx.getWorld();
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        double powerRating = ctx.getBender().calcPowerRating(Lightningbending.ID);
        if (world.field_72995_K) {
            return false;
        }
        int duration = data.getTickHandlerDuration(this);
        float movementMultiplier = 0.6f - 0.7f * MathHelper.func_76129_c((float)((float)duration / 40.0f));
        this.applyMovementModifier(entity, MathHelper.func_76131_a((float)movementMultiplier, (float)0.1f, (float)1.0f));
        double inverseRadius = (40.0f - (float)duration) / 10.0f;
        if (duration % 3 == 0) {
            for (int i = 0; i < 8; ++i) {
                Vector lookpos = Vector.toRectangular(Math.toRadians(entity.field_70177_z + (float)(i * 45)), 0.0).times(inverseRadius).withY(entity.func_70047_e() / 2.0f);
                this.particleSpawner.spawnParticles(world, AvatarParticles.getParticleElectricity(), 1, 2, lookpos.x() + entity.field_70165_t, lookpos.y() + entity.func_174813_aQ().field_72338_b, lookpos.z() + entity.field_70161_v, 2.0, 1.2, 2.0, true, new int[0]);
            }
        }
        if (duration >= 40) {
            AbilityData abilityData = this.getLightningData(ctx);
            if (abilityData == null) {
                return true;
            }
            double speed = abilityData.getLevel() >= 1 ? 30.0 : 40.0;
            float damage = abilityData.getLevel() >= 2 ? 8.0f : 6.0f;
            float size = 1.0f;
            float[] turbulenceValues = new float[]{0.6f, 1.2f};
            if (abilityData.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
                damage = 12.0f;
                size = 0.75f;
                turbulenceValues = new float[]{0.6f, 1.2f, 0.8f};
            }
            if (abilityData.isMasterPath(AbilityData.AbilityTreePath.SECOND)) {
                size = 1.5f;
            }
            damage = (float)((double)damage * ctx.getBender().getDamageMult(Lightningbending.ID));
            this.fireLightning(world, entity, damage, speed += powerRating / 15.0, size, turbulenceValues);
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(MOVEMENT_MODIFIER_ID);
            world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 1.0f, 2.0f);
            return true;
        }
        return false;
    }

    private void fireLightning(World world, EntityLivingBase entity, float damage, double speed, float size, float[] turbulenceValues) {
        for (float turbulence : turbulenceValues) {
            EntityLightningArc lightning = new EntityLightningArc(world);
            lightning.setOwner(entity);
            lightning.setTurbulence(turbulence);
            lightning.setDamage(damage);
            lightning.setSizeMultiplier(size);
            lightning.setAbility(new AbilityLightningArc());
            lightning.setMainArc(turbulence == turbulenceValues[0]);
            lightning.setPosition(Vector.getEyePos((Entity)entity));
            lightning.setEndPos(Vector.getEyePos((Entity)entity));
            Vector velocity = Vector.getLookRectangular((Entity)entity);
            velocity = velocity.normalize().times(speed);
            lightning.setVelocity(velocity);
            world.func_72838_d((Entity)lightning);
        }
    }

    private void applyMovementModifier(EntityLivingBase entity, float multiplier) {
        IAttributeInstance moveSpeed = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        moveSpeed.func_188479_b(MOVEMENT_MODIFIER_ID);
        moveSpeed.func_111121_a(new AttributeModifier(MOVEMENT_MODIFIER_ID, "Lightning charge modifier", (double)(multiplier - 1.0f), 1));
    }
}

