/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.lightning;

import com.crowsofwar.avatar.bending.bending.lightning.LightningChargeHandler;
import com.crowsofwar.avatar.joml.SimplexNoise;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BenderInfo;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class LightningRedirectHandler
extends LightningChargeHandler {
    public LightningRedirectHandler(int id) {
        super(id);
    }

    @Override
    @Nullable
    protected AbilityData getLightningData(BendingContext ctx) {
        BendingData data = ctx.getData();
        World world = ctx.getWorld();
        BenderInfo originalShooter = data.getMiscData().getRedirectionSource();
        if (originalShooter.find(world) == null) {
            return null;
        }
        return BendingData.get(world, originalShooter).getAbilityData("lightning_arc");
    }

    @Override
    public boolean tick(BendingContext ctx) {
        this.applyShakiness(ctx.getBenderEntity());
        return super.tick(ctx);
    }

    private void applyShakiness(EntityLivingBase entity) {
        float ticks = entity.field_70173_aa;
        float modPitch = SimplexNoise.noise(ticks / 25.0f, 0.0f);
        float modYaw = SimplexNoise.noise(ticks / 25.0f, 1000.0f);
        entity.field_70177_z += modYaw * 4.0f;
        entity.field_70125_A += modPitch * 4.0f;
    }
}

