/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.lightning;

import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityLightningSpear;
import com.crowsofwar.avatar.entity.data.LightningSpearBehavior;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class StatCtrlThrowLightningSpear
extends StatusControl {
    public StatCtrlThrowLightningSpear() {
        super(14, AvatarControl.CONTROL_LEFT_CLICK, StatusControl.CrosshairPosition.LEFT_OF_CROSSHAIR);
    }

    @Override
    public boolean execute(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        World world = ctx.getWorld();
        EntityLightningSpear spear = AvatarEntity.lookupControlledEntity(world, EntityLightningSpear.class, entity);
        if (spear != null) {
            double speedMult;
            AbilityData abilityData = ctx.getData().getAbilityData("lightning_spear");
            double d = speedMult = abilityData.getLevel() >= 1 ? 55.0 : 45.0;
            if (abilityData.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
                speedMult = 80.0;
            }
            spear.setBehavior(new LightningSpearBehavior.Thrown());
            spear.setVelocity(Vector.getLookRectangular((Entity)entity).times(speedMult));
            Vector direction = spear.velocity().toSpherical();
            spear.field_70177_z = (float)Math.toDegrees(direction.y());
            spear.field_70125_A = (float)Math.toDegrees(direction.x());
        }
        return true;
    }
}

