/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.sand;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.sand.Sandbending;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntitySandPrison;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AbilitySandPrison
extends Ability {
    public AbilitySandPrison() {
        super(Sandbending.ID, "sand_prison");
    }

    @Override
    public boolean isUtility() {
        return true;
    }

    @Override
    public void execute(AbilityContext ctx) {
        Bender bender = ctx.getBender();
        if (bender.consumeChi(ConfigStats.STATS_CONFIG.chiSandPrison)) {
            Predicate<Entity> filter;
            Vector direction;
            Vector start;
            EntityLivingBase entity = ctx.getBenderEntity();
            World world = ctx.getWorld();
            List<Entity> hit = Raytrace.entityRaytrace(world, start = Vector.getEyePos((Entity)entity), direction = Vector.getLookRectangular((Entity)entity), 10.0, filter = candidate -> candidate != entity && candidate instanceof EntityLivingBase);
            if (!hit.isEmpty()) {
                boolean allowEarthbendable = ctx.getAbilityData().getLevel() >= 1;
                EntityLivingBase prisoner = (EntityLivingBase)hit.get(0);
                if (this.canImprison(prisoner, allowEarthbendable)) {
                    EntitySandPrison.imprison(prisoner, entity, this);
                    world.func_184133_a(null, prisoner.func_180425_c(), SoundEvents.field_187755_eF, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    ctx.getAbilityData().addXp(ConfigSkills.SKILLS_CONFIG.sandPrisoned);
                } else {
                    String suffix = allowEarthbendable ? "bendable" : "sand";
                    bender.sendMessage("avatar.sandPrisonDisabled." + suffix);
                }
            }
        }
    }

    private boolean canImprison(EntityLivingBase target, boolean allowEarthbendable) {
        BlockPos pos = target.func_180425_c().func_177977_b();
        World world = target.field_70170_p;
        Block standingOn = world.func_180495_p(pos).func_177230_c();
        List<Block> blocksList = allowEarthbendable ? ConfigStats.STATS_CONFIG.bendableBlocks : ConfigStats.STATS_CONFIG.sandBlocks;
        return blocksList.contains(standingOn);
    }

    @Override
    public int getBaseParentTier() {
        return 3;
    }
}

