/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.sand;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.sand.Sandbending;
import com.crowsofwar.avatar.entity.EntitySandstorm;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class AbilitySandstorm
extends Ability {
    public static final String CONTACT_DAMAGE = "contactDamage";
    public static final String FLUNG_DAMAGE = "flungDamage";
    public static final String VULNERABLE = "vulnerableAirbending";

    public AbilitySandstorm() {
        super(Sandbending.ID, "sandstorm");
    }

    @Override
    public void init() {
        super.init();
        this.addBooleanProperties(FLUNG_DAMAGE, CONTACT_DAMAGE, VULNERABLE);
    }

    @Override
    public void execute(AbilityContext ctx) {
        World world = ctx.getWorld();
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        if (bender.consumeChi(this.getChiCost(ctx))) {
            AbilityData abilityData = ctx.getAbilityData();
            float speed = this.powerModify(this.getProperty("speed", ctx).floatValue(), abilityData) / 10.0f;
            float size = this.powerModify(this.getProperty("size", ctx).floatValue(), abilityData);
            float push = this.powerModify(this.getProperty("knockback", ctx).floatValue(), abilityData) * 6.0f;
            float damage = this.powerModify(this.getProperty("damage", ctx).floatValue(), abilityData);
            Vector velocity = Vector.toRectangular(Math.toRadians(entity.field_70177_z), 0.0).times(8.0).times(speed);
            EntitySandstorm sandstorm = new EntitySandstorm(world);
            sandstorm.setPosition(Vector.getEntityPos((Entity)entity));
            sandstorm.setOwner(entity);
            sandstorm.setVelocity(velocity);
            sandstorm.setAbility(this);
            sandstorm.setVelocityMultiplier(speed);
            sandstorm.setDamageFlungTargets(this.getBooleanProperty(FLUNG_DAMAGE, ctx));
            sandstorm.setDamageContactingTargets(this.getBooleanProperty(CONTACT_DAMAGE, ctx));
            sandstorm.setVulnerableToAirbending(this.getBooleanProperty(VULNERABLE, ctx));
            sandstorm.setEntitySize(size * 2.0f, size);
            sandstorm.setTier(this.getBaseTier());
            sandstorm.setPush(push);
            sandstorm.setElement(new Sandbending());
            sandstorm.setDamage(damage);
            sandstorm.setChiHit(this.powerModify(this.getProperty("chiOnHit", ctx).floatValue(), abilityData));
            sandstorm.setPerformanceAmount(this.getProperty("performanceAmount", ctx).intValue());
            sandstorm.setLifeTime((int)this.powerModify(this.getProperty("lifeTime", ctx).intValue(), abilityData));
            sandstorm.setDamageSource("avatar_Sand_sandstorm");
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)sandstorm);
            }
            ctx.getData().addStatusControl(StatusControlController.SANDSTORM_REDIRECT);
        }
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean isOffensive() {
        return true;
    }

    @Override
    public int getBaseTier() {
        return 2;
    }

    @Override
    public int getBaseParentTier() {
        return 4;
    }
}

