/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.water;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import com.crowsofwar.avatar.bending.bending.water.tickhandlers.CleansePowerModifier;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class AbilityCleanse
extends Ability {
    public AbilityCleanse() {
        super(Waterbending.ID, "cleanse");
    }

    @Override
    public boolean isBuff() {
        return true;
    }

    @Override
    public void execute(AbilityContext ctx) {
        BendingData data = ctx.getData();
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        AbilityData abilityData = data.getAbilityData(this);
        float chi = ConfigStats.STATS_CONFIG.chiBuff;
        if (abilityData.getLevel() == 1) {
            chi = ConfigStats.STATS_CONFIG.chiBuffLvl2;
        } else if (abilityData.getLevel() == 2) {
            chi = ConfigStats.STATS_CONFIG.chiBuffLvl3;
        } else if (abilityData.getLevel() == 3) {
            chi = ConfigStats.STATS_CONFIG.chiBuffLvl4;
        }
        Vector targetPos = this.getClosestWaterBlock(entity, ctx.getLevel() * 3);
        if (bender.consumeChi(chi) && targetPos != null || entity instanceof EntityPlayerMP && ((EntityPlayerMP)entity).func_184812_l_() || ctx.consumeWater(4)) {
            int duration = abilityData.getLevel() < 2 ? 100 : 200;
            int regenLevel = MathHelper.func_76125_a((int)abilityData.getLevel(), (int)0, (int)2);
            abilityData.addXp(ConfigSkills.SKILLS_CONFIG.buffUsed);
            entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, duration, regenLevel));
            if (abilityData.getLevel() >= 2) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76443_y, duration));
            }
            if (abilityData.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76444_x, duration, 1));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76443_y, duration, 1));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 0, 0));
            }
            if (abilityData.isMasterPath(AbilityData.AbilityTreePath.SECOND)) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76427_o, duration));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76424_c, duration, 1));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, duration));
            }
            if (abilityData.getLevel() >= 1) {
                int groupLevel = abilityData.isMasterPath(AbilityData.AbilityTreePath.FIRST) ? 1 : 0;
                int groupDuration = abilityData.getLevel() == 3 ? 100 : 60;
                int groupRadius = abilityData.getLevel() >= 2 ? 6 : 4;
                PotionEffect groupEffect = new PotionEffect(MobEffects.field_76428_l, groupDuration, groupLevel);
                this.applyGroupEffect(ctx, groupRadius, player -> player.func_70690_d(groupEffect));
                this.applyGroupEffect(ctx, groupRadius, this::addChiBonus);
            }
            CleansePowerModifier modifier = new CleansePowerModifier();
            modifier.setTicks(duration);
            data.getPowerRatingManager(this.getBendingId()).addModifier(modifier, ctx);
        } else {
            bender.sendMessage("avatar.cleanseFail");
        }
    }

    private void applyGroupEffect(AbilityContext ctx, int radius, Consumer<EntityPlayer> effect) {
        World world = ctx.getWorld();
        EntityLivingBase entity = ctx.getBenderEntity();
        AxisAlignedBB aabb = new AxisAlignedBB(entity.field_70165_t - (double)radius, entity.field_70163_u - (double)radius, entity.field_70161_v - (double)radius, entity.field_70165_t + (double)radius, entity.field_70163_u + (double)radius, entity.field_70161_v + (double)radius);
        List players = world.func_72872_a(EntityPlayer.class, aabb);
        for (EntityPlayer player : players) {
            if (player.func_70068_e((Entity)entity) > (double)(radius * radius) || player == entity) continue;
            effect.accept(player);
        }
    }

    private void addChiBonus(EntityPlayer player) {
        BendingData data = BendingData.getFromEntity((EntityLivingBase)player);
        if (data != null) {
            data.chi().changeTotalChi(ConfigStats.STATS_CONFIG.cleanseChiGroupBonus);
            data.chi().changeAvailableChi(ConfigStats.STATS_CONFIG.cleanseChiGroupBonus);
        }
    }

    private Vector getClosestWaterBlock(EntityLivingBase entity, int level) {
        World world = entity.field_70170_p;
        Vector eye = Vector.getEyePos((Entity)entity);
        double rangeMult = 0.6;
        if (level >= 1) {
            rangeMult = 1.0;
        }
        double range = ConfigStats.STATS_CONFIG.cleanseSearchRadius * rangeMult;
        int i = 0;
        while ((double)i < ConfigStats.STATS_CONFIG.cleanseAngles) {
            int j = 0;
            while ((double)j < ConfigStats.STATS_CONFIG.cleanseAngles) {
                double yaw = (double)entity.field_70177_z + (double)i * 360.0 / ConfigStats.STATS_CONFIG.cleanseAngles;
                double pitch = (double)entity.field_70125_A + (double)j * 360.0 / ConfigStats.STATS_CONFIG.cleanseAngles;
                BiPredicate<BlockPos, IBlockState> isWater = (pos, state) -> state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i || state.func_177230_c() == Blocks.field_150432_aD || state.func_177230_c() == Blocks.field_150431_aC || state.func_177230_c() == Blocks.field_150433_aE;
                Vector angle = Vector.toRectangular(Math.toRadians(yaw), Math.toRadians(pitch));
                Raytrace.Result result = Raytrace.predicateRaytrace(world, eye, angle, range, isWater);
                if (result.hitSomething()) {
                    return result.getPosPrecise();
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getBaseTier() {
        return 5;
    }

    @Override
    public int getCooldown(AbilityContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        int coolDown = 160;
        if (ctx.getLevel() == 1) {
            coolDown = 140;
        }
        if (ctx.getLevel() == 2) {
            coolDown = 120;
        }
        if (ctx.isDynamicMasterLevel(AbilityData.AbilityTreePath.FIRST)) {
            coolDown = 130;
        }
        if (ctx.isDynamicMasterLevel(AbilityData.AbilityTreePath.SECOND)) {
            coolDown = 110;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
            coolDown = 0;
        }
        return coolDown;
    }
}

