/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.water;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingAi;
import com.crowsofwar.avatar.bending.bending.water.AiWave;
import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityWave;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import com.crowsofwar.gorecore.util.VectorI;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class AbilityCreateWave
extends Ability {
    public AbilityCreateWave() {
        super(Waterbending.ID, "wave");
    }

    @Override
    public void execute(AbilityContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        World world = ctx.getWorld();
        Vector look = Vector.getLookRectangular((Entity)entity);
        Raytrace.Result result = Raytrace.predicateRaytrace(world, Vector.getEntityPos((Entity)entity).minusY(1.0), look, 4 + ctx.getLevel(), (pos, blockState) -> blockState.func_177230_c() == Blocks.field_150355_j);
        if (result.hitSomething()) {
            VectorI pos2 = result.getPos();
            assert (pos2 != null);
            IBlockState up = world.func_180495_p(pos2.toBlockPos().func_177984_a());
            for (int i = 0; i < 3; ++i) {
                if (up.func_177230_c() == Blocks.field_150350_a) {
                    if (!bender.consumeChi(ConfigStats.STATS_CONFIG.chiWave)) break;
                    float size = 2.0f;
                    double speed = 6.5;
                    if (ctx.isMasterLevel(AbilityData.AbilityTreePath.FIRST)) {
                        speed = 12.5;
                        size = 5.0f;
                    }
                    if (ctx.isMasterLevel(AbilityData.AbilityTreePath.SECOND)) {
                        speed = 17.0;
                        size = 2.75f;
                    }
                    if (ctx.getLevel() == 1) {
                        size = 2.5f;
                        speed = 8.0;
                    }
                    if (ctx.getLevel() == 2) {
                        size = 3.0f;
                        speed = 10.0;
                    }
                    size = (float)((double)size + ctx.getPowerRating() / 100.0);
                    EntityWave wave = new EntityWave(world);
                    wave.setOwner(entity);
                    wave.setVelocity(look.times(speed += ctx.getPowerRating() / 100.0 * 8.0));
                    wave.func_70107_b(pos2.x(), pos2.y(), pos2.z());
                    wave.setAbility(this);
                    wave.field_70177_z = (float)Math.toDegrees(look.toSpherical().y());
                    float damageMult = ctx.getLevel() >= 1 ? 1.5f : 1.0f;
                    damageMult = (float)((double)damageMult * ctx.getPowerRatingDamageMod());
                    wave.setDamageMultiplier(damageMult);
                    wave.setWaveSize(size);
                    wave.setCreateExplosion(ctx.isMasterLevel(AbilityData.AbilityTreePath.SECOND));
                    world.func_72838_d((Entity)wave);
                    break;
                }
                pos2.add(0, 1, 0);
            }
        }
    }

    @Override
    public int getBaseTier() {
        return 2;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean isOffensive() {
        return true;
    }

    @Override
    public BendingAi getAi(EntityLiving entity, Bender bender) {
        return new AiWave(this, entity, bender);
    }
}

