/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.water;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingAi;
import com.crowsofwar.avatar.bending.bending.water.AiWaterArc;
import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityWaterArc;
import com.crowsofwar.avatar.entity.data.WaterArcBehavior;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.function.BiPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AbilityWaterArc
extends Ability {
    public AbilityWaterArc() {
        super(Waterbending.ID, "water_arc");
        this.requireRaytrace(-1.0, true);
    }

    @Override
    public void execute(AbilityContext ctx) {
        World world = ctx.getWorld();
        Bender bender = ctx.getBender();
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        Vector targetPos = this.getClosestWaterbendableBlock(entity, ctx.getLevel() * 2);
        if (targetPos != null || ctx.consumeWater(1) || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
            if (targetPos == null) {
                targetPos = Vector.getEyePos((Entity)entity).plus(Vector.getLookRectangular((Entity)entity).times(2.5));
            }
            if (targetPos != null && entity instanceof EntityPlayer && !((EntityPlayer)entity).func_184812_l_()) {
                world.func_175698_g(targetPos.toBlockPos());
            }
            float damageMult = 1.0f;
            float gravity = 8.0f;
            float size = 0.5f;
            if (ctx.getLevel() == 1) {
                damageMult = 1.25f;
                gravity = 7.5f;
                size = 0.65f;
            }
            if (ctx.getLevel() == 2) {
                damageMult = 1.5f;
                gravity = 7.0f;
                size = 0.8f;
            }
            if (ctx.isDynamicMasterLevel(AbilityData.AbilityTreePath.SECOND)) {
                damageMult = 3.0f;
                gravity = 3.0f;
                size = 0.4f;
            }
            if (ctx.isDynamicMasterLevel(AbilityData.AbilityTreePath.FIRST)) {
                gravity = 9.81f;
                size = 0.5f;
            }
            if (bender.consumeChi(ConfigStats.STATS_CONFIG.chiWaterArc)) {
                this.removeExisting(ctx);
                EntityWaterArc water = new EntityWaterArc(world);
                water.setOwner(entity);
                assert (targetPos != null);
                water.func_70107_b(targetPos.x() + 0.5, targetPos.y() - 0.5, targetPos.z() + 0.5);
                water.setDamageMult(damageMult);
                water.setEntitySize(size);
                water.setDamage(damageMult * ConfigStats.STATS_CONFIG.waterArcSettings.damage);
                water.setXp(ConfigSkills.SKILLS_CONFIG.waterHit);
                water.setTier(this.getCurrentTier(ctx));
                water.setLifeTime(30);
                water.setBehavior(new WaterArcBehavior.PlayerControlled());
                water.isSpear(ctx.isDynamicMasterLevel(AbilityData.AbilityTreePath.SECOND));
                water.setGravity(gravity);
                water.setAbility(this);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)water);
                }
                ctx.getData().addStatusControl(StatusControlController.THROW_WATER);
            }
        }
    }

    private Vector getClosestWaterbendableBlock(EntityLivingBase entity, int level) {
        World world = entity.field_70170_p;
        Vector eye = Vector.getEyePos((Entity)entity);
        double rangeMult = 0.6;
        if (level >= 1) {
            rangeMult = 1.0;
        }
        double range = ConfigStats.STATS_CONFIG.waterArcSearchRadius * rangeMult;
        int i = 0;
        while ((double)i < ConfigStats.STATS_CONFIG.waterArcAngles) {
            int j = 0;
            while ((double)j < ConfigStats.STATS_CONFIG.waterArcAngles) {
                double yaw = (double)entity.field_70177_z + (double)i * 360.0 / ConfigStats.STATS_CONFIG.waterArcAngles;
                double pitch = (double)entity.field_70125_A + (double)j * 360.0 / ConfigStats.STATS_CONFIG.waterArcAngles;
                BiPredicate<BlockPos, IBlockState> isWater = (pos, state) -> (ConfigStats.STATS_CONFIG.waterBendableBlocks.contains(state.func_177230_c()) || ConfigStats.STATS_CONFIG.plantBendableBlocks.contains(state.func_177230_c())) && state.func_177230_c() != Blocks.field_150350_a;
                Vector angle = Vector.toRectangular(Math.toRadians(yaw), Math.toRadians(pitch));
                Raytrace.Result result = Raytrace.predicateRaytrace(world, eye, angle, range, isWater);
                if (result.hitSomething()) {
                    return result.getPosPrecise();
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private void removeExisting(AbilityContext ctx) {
        EntityWaterArc water = AvatarEntity.lookupControlledEntity(ctx.getWorld(), EntityWaterArc.class, ctx.getBenderEntity());
        if (water != null) {
            water.setBehavior(new WaterArcBehavior.Thrown());
        }
    }

    @Override
    public BendingAi getAi(EntityLiving entity, Bender bender) {
        return new AiWaterArc(this, entity, bender);
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean isOffensive() {
        return true;
    }
}

