/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.water;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.function.BiPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AbilityWaterBlast
extends Ability {
    public AbilityWaterBlast() {
        super(Waterbending.ID, "water_blast");
        this.requireRaytrace(-1.0, false);
    }

    @Override
    public void execute(AbilityContext ctx) {
        Bender bender = ctx.getBender();
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        World world = ctx.getWorld();
        Vector targetPos = this.getClosestWaterbendableBlock(entity, ctx.getLevel() * 2);
        float chi = ConfigStats.STATS_CONFIG.chiWaterCannon;
        boolean hasWaterCharge = data.hasTickHandler(TickHandlerController.WATER_CHARGE);
        int waterAmount = 2;
        if (ctx.getLevel() >= 2) {
            waterAmount = 3;
        }
        if (ctx.getLevel() == 2) {
            chi = ConfigStats.STATS_CONFIG.chiWaterCannon * 1.2f;
        }
        if (ctx.isMasterLevel(AbilityData.AbilityTreePath.FIRST)) {
            chi = ConfigStats.STATS_CONFIG.chiWaterCannon * 1.6f;
        }
        if (ctx.isMasterLevel(AbilityData.AbilityTreePath.SECOND)) {
            chi = ConfigStats.STATS_CONFIG.chiWaterCannon * 1.4f;
        }
        if (ctx.consumeWater(waterAmount)) {
            if (bender.consumeChi(chi) && !hasWaterCharge) {
                ctx.getData().addTickHandler(TickHandlerController.WATER_CHARGE, ctx);
                data.addTickHandler(TickHandlerController.WATER_PARTICLE_SPAWNER, ctx);
            }
        } else if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
            if (!hasWaterCharge) {
                ctx.getData().addTickHandler(TickHandlerController.WATER_CHARGE, ctx);
                data.addTickHandler(TickHandlerController.WATER_PARTICLE_SPAWNER, ctx);
            }
        } else if (targetPos != null && ctx.getLevel() >= 2) {
            if (bender.consumeChi(chi) && !hasWaterCharge) {
                world.func_175698_g(targetPos.toBlockPos());
                ctx.getData().addTickHandler(TickHandlerController.WATER_CHARGE, ctx);
                data.addTickHandler(TickHandlerController.WATER_PARTICLE_SPAWNER, ctx);
            }
        } else {
            bender.sendMessage("avatar.waterSourceFail");
        }
    }

    private Vector getClosestWaterbendableBlock(EntityLivingBase entity, int level) {
        World world = entity.field_70170_p;
        Vector eye = Vector.getEyePos((Entity)entity);
        double rangeMult = 0.6;
        if (level >= 1) {
            rangeMult = 1.0;
        }
        double range = ConfigStats.STATS_CONFIG.waterCannonSettings.waterCannonSearchRadius * rangeMult;
        int i = 0;
        while ((double)i < ConfigStats.STATS_CONFIG.waterCannonSettings.waterCannonAngles) {
            int j = 0;
            while ((double)j < ConfigStats.STATS_CONFIG.waterCannonSettings.waterCannonAngles) {
                double yaw = (double)entity.field_70177_z + (double)i * 360.0 / ConfigStats.STATS_CONFIG.waterCannonSettings.waterCannonAngles;
                double pitch = (double)entity.field_70125_A + (double)j * 360.0 / ConfigStats.STATS_CONFIG.waterCannonSettings.waterCannonAngles;
                BiPredicate<BlockPos, IBlockState> isWater = (pos, state) -> (ConfigStats.STATS_CONFIG.waterBendableBlocks.contains(state.func_177230_c()) || ConfigStats.STATS_CONFIG.plantBendableBlocks.contains(state.func_177230_c())) && state.func_177230_c() != Blocks.field_150350_a;
                Vector angle = Vector.toRectangular(Math.toRadians(yaw), Math.toRadians(pitch));
                Raytrace.Result result = Raytrace.predicateRaytrace(world, eye, angle, range, isWater);
                if (result.hitSomething()) {
                    return result.getPosPrecise();
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getBaseTier() {
        return 3;
    }

    @Override
    public boolean isChargeable() {
        return true;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean isOffensive() {
        return true;
    }
}

