/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.water;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityWaterBubble;
import com.crowsofwar.avatar.entity.data.WaterBubbleBehavior;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.function.BiPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AbilityWaterBubble
extends Ability {
    public AbilityWaterBubble() {
        super(Waterbending.ID, "water_bubble");
        this.requireRaytrace(-1.0, false);
    }

    @Override
    public boolean isUtility() {
        return true;
    }

    @Override
    public void execute(AbilityContext ctx) {
        BlockPos lookPos;
        IBlockState lookingAtBlock;
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        BendingData data = ctx.getData();
        World world = ctx.getWorld();
        Vector targetPos = this.getClosestWaterbendableBlock(entity, ctx.getLevel() * 2);
        if (ctx.isLookingAtBlock() && (ConfigStats.STATS_CONFIG.waterBendableBlocks.contains((lookingAtBlock = world.func_180495_p(lookPos = ctx.getLookPosI().toBlockPos())).func_177230_c()) || ConfigStats.STATS_CONFIG.plantBendableBlocks.contains(lookingAtBlock.func_177230_c())) && bender.consumeChi(ConfigStats.STATS_CONFIG.chiWaterBubble)) {
            EntityWaterBubble existing = AvatarEntity.lookupEntity(world, EntityWaterBubble.class, bub -> bub.getBehavior() instanceof WaterBubbleBehavior.PlayerControlled && bub.getOwner() == entity);
            if (existing != null) {
                existing.setBehavior(new WaterBubbleBehavior.Drop());
                existing.setOwner(null);
            }
            Vector pos = ctx.getLookPos();
            EntityWaterBubble bubble = new EntityWaterBubble(world);
            assert (pos != null);
            bubble.func_70107_b(pos.x(), pos.y(), pos.z());
            bubble.setBehavior(new WaterBubbleBehavior.PlayerControlled());
            bubble.setOwner(entity);
            bubble.setSourceBlock(ctx.getLevel() >= 2);
            bubble.setAbility(this);
            bubble.setVelocity(Vector.UP);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)bubble);
            }
            data.addStatusControl(StatusControlController.LOB_BUBBLE);
            data.getAbilityData(this).addXp(ConfigSkills.SKILLS_CONFIG.createBubble);
            if (!ctx.isMasterLevel(AbilityData.AbilityTreePath.SECOND)) {
                world.func_175698_g(lookPos);
            }
        }
    }

    private Vector getClosestWaterbendableBlock(EntityLivingBase entity, int level) {
        World world = entity.field_70170_p;
        Vector eye = Vector.getEyePos((Entity)entity);
        double rangeMult = 0.6;
        if (level >= 1) {
            rangeMult = 1.0;
        }
        double range = ConfigStats.STATS_CONFIG.waterBubbleSearchRadius * rangeMult;
        int i = 0;
        while ((double)i < ConfigStats.STATS_CONFIG.waterBubbleAngles) {
            int j = 0;
            while ((double)j < ConfigStats.STATS_CONFIG.waterBubbleAngles) {
                double yaw = (double)entity.field_70177_z + (double)i * 360.0 / ConfigStats.STATS_CONFIG.waterBubbleAngles;
                double pitch = (double)entity.field_70125_A + (double)j * 360.0 / ConfigStats.STATS_CONFIG.waterBubbleAngles;
                BiPredicate<BlockPos, IBlockState> isWater = (pos, state) -> (ConfigStats.STATS_CONFIG.waterBendableBlocks.contains(state.func_177230_c()) || ConfigStats.STATS_CONFIG.plantBendableBlocks.contains(state.func_177230_c())) && state.func_177230_c() != Blocks.field_150350_a;
                Vector angle = Vector.toRectangular(Math.toRadians(yaw), Math.toRadians(pitch));
                Raytrace.Result result = Raytrace.predicateRaytrace(world, eye, angle, range, isWater);
                if (result.hitSomething()) {
                    return result.getPosPrecise();
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isChargeable() {
        return true;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean isOffensive() {
        return true;
    }
}

