/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.water.statctrls;

import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityWaterBubble;
import com.crowsofwar.avatar.entity.data.WaterBubbleBehavior;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;

public class StatCtrlLobBubble
extends StatusControl {
    public StatCtrlLobBubble() {
        super(7, AvatarControl.CONTROL_RIGHT_CLICK_DOWN, StatusControl.CrosshairPosition.RIGHT_OF_CROSSHAIR);
    }

    @Override
    public boolean execute(BendingContext ctx) {
        BendingData data = ctx.getData();
        double powerRating = ctx.getBender().calcPowerRating(Waterbending.ID);
        EntityWaterBubble bubble = AvatarEntity.lookupEntity(ctx.getWorld(), EntityWaterBubble.class, bub -> bub.getBehavior() instanceof WaterBubbleBehavior.PlayerControlled && bub.getOwner() == ctx.getBenderEntity());
        if (bubble != null) {
            double speed;
            AbilityData adata = data.getAbilityData("water_bubble");
            double d = speed = adata.getLevel() >= 1 ? 16.0 : 10.0;
            if (adata.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
                speed = 22.0;
            }
            bubble.setBehavior(new WaterBubbleBehavior.Lobbed());
            bubble.addVelocity(bubble.velocity().dividedBy(-1.0));
            bubble.addVelocity(Vector.getLookRectangular((Entity)ctx.getBenderEntity()).times(speed += powerRating / 30.0));
        }
        return true;
    }
}

