/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.water.statctrls;

import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityWaterArc;
import com.crowsofwar.avatar.entity.data.WaterArcBehavior;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class StatCtrlThrowWater
extends StatusControl {
    public StatCtrlThrowWater() {
        super(3, AvatarControl.CONTROL_LEFT_CLICK, StatusControl.CrosshairPosition.LEFT_OF_CROSSHAIR);
    }

    @Override
    public boolean execute(BendingContext ctx) {
        EntityWaterArc arc;
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        World world = ctx.getWorld();
        AbilityData abilityData = data.getAbilityData("water_arc");
        int lvl = abilityData.getLevel();
        double velocity = 14.0;
        if (lvl == 1) {
            velocity = 16.0;
        }
        if (lvl == 2) {
            velocity = 18.0;
        }
        if (lvl == 3) {
            velocity = 22.0;
        }
        if ((arc = AvatarEntity.lookupEntity(ctx.getWorld(), EntityWaterArc.class, water -> water.getBehavior() instanceof WaterArcBehavior.PlayerControlled && water.getOwner() == ctx.getBenderEntity())) != null) {
            Vector force = Vector.toRectangular(Math.toRadians(entity.field_70177_z), Math.toRadians(entity.field_70125_A));
            force = force.times(velocity);
            arc.addVelocity(arc.velocity().dividedBy(-1.0));
            arc.addVelocity(force);
            arc.setBehavior(new WaterArcBehavior.Thrown());
        }
        return true;
    }
}

