/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.water.tickhandlers;

import com.crowsofwar.avatar.bending.bending.water.AbilityWaterBlast;
import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityLightCylinder;
import com.crowsofwar.avatar.entity.EntityWaterCannon;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.entity.data.LightCylinderBehaviour;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.TickHandler;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class WaterChargeHandler
extends TickHandler {
    public static final UUID MOVEMENT_MODIFIER_ID = UUID.fromString("87a0458a-38ea-4d7a-be3b-0fee10217aa6");

    public WaterChargeHandler(int id) {
        super(id);
    }

    @Override
    public boolean tick(BendingContext ctx) {
        AbilityData abilityData = ctx.getData().getAbilityData("water_blast");
        World world = ctx.getWorld();
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        Bender bender = ctx.getBender();
        double powerRating = ctx.getBender().calcPowerRating(Waterbending.ID);
        int duration = data.getTickHandlerDuration(this);
        double speed = abilityData.isMasterPath(AbilityData.AbilityTreePath.SECOND) ? 40.0 : 0.0;
        float maxRange = abilityData.getLevel() >= 1 ? 40.0f : 60.0f;
        Vec3d knockback = entity.func_70040_Z().func_186678_a((double)(maxRange / 50.0f)).func_186678_a(ConfigStats.STATS_CONFIG.waterCannonSettings.waterCannonKnockbackMult);
        float movementMultiplier = 0.6f - 0.7f * MathHelper.func_76129_c((float)((float)duration / 40.0f));
        float ticks = 50.0f;
        int durationToFire = 40;
        if (abilityData.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
            durationToFire = 60;
        }
        this.applyMovementModifier(entity, MathHelper.func_76131_a((float)movementMultiplier, (float)0.1f, (float)1.0f));
        if (abilityData.isMasterPath(AbilityData.AbilityTreePath.SECOND)) {
            float size = 0.1f;
            ticks = 50.0f;
            float damage = (float)(ConfigStats.STATS_CONFIG.waterCannonSettings.waterCannonDamage * 0.5 * bender.getDamageMult(Waterbending.ID));
            knockback.func_186678_a((double)damage);
            if (duration >= 40 && duration % 10 == 0) {
                this.fireCannon(world, entity, damage, speed, size, ticks, maxRange, knockback);
                world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187917_gq, SoundCategory.PLAYERS, 1.0f, 2.0f);
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(MOVEMENT_MODIFIER_ID);
                return duration >= 100;
            }
        } else if (duration >= durationToFire) {
            speed = abilityData.getLevel() >= 1 ? 20.0 : 30.0;
            speed += powerRating / 15.0;
            float damage = (float)(ConfigStats.STATS_CONFIG.waterCannonSettings.waterCannonDamage * bender.getDamageMult(Waterbending.ID));
            float size = 0.5f;
            if (abilityData.getLevel() >= 1) {
                damage = (float)(ConfigStats.STATS_CONFIG.waterCannonSettings.waterCannonDamage * 1.25 * bender.getDamageMult(Waterbending.ID));
                size = 0.75f;
                ticks = 75.0f;
            }
            if (abilityData.getLevel() >= 2) {
                damage = (float)(ConfigStats.STATS_CONFIG.waterCannonSettings.waterCannonDamage * 1.5 * bender.getDamageMult(Waterbending.ID));
                size = 1.0f;
                ticks = 100.0f;
            }
            if (abilityData.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
                damage = (float)(ConfigStats.STATS_CONFIG.waterCannonSettings.waterCannonDamage * 2.5 * bender.getDamageMult(Waterbending.ID));
                ticks = 125.0f;
            }
            damage = (float)((double)damage * bender.getDamageMult(Waterbending.ID));
            knockback.func_186678_a((double)damage);
            this.fireCannon(world, entity, damage, speed, size, ticks, maxRange, knockback);
            world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187547_bF, SoundCategory.PLAYERS, 1.0f, 2.0f);
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(MOVEMENT_MODIFIER_ID);
            return true;
        }
        return false;
    }

    private void fireCannon(World world, EntityLivingBase entity, float damage, double speed, float size, float ticks, float maxRange, Vec3d knockBack) {
        EntityWaterCannon cannon = new EntityWaterCannon(world);
        cannon.setOwner(entity);
        cannon.setDamage(damage);
        cannon.setEntitySize(1.5f * size);
        cannon.setPosition(Vector.getEyePos((Entity)entity).minusY(0.8));
        cannon.setLifeTime((int)ticks);
        cannon.setXp(ConfigSkills.SKILLS_CONFIG.waterHit / 2.0f);
        cannon.field_70125_A = entity.field_70125_A;
        cannon.field_70177_z = entity.field_70177_z;
        cannon.setTier(new AbilityWaterBlast().getCurrentTier(AbilityData.get(entity, "water_blast")));
        cannon.setAbility(new AbilityWaterBlast());
        Vector velocity = Vector.getLookRectangular((Entity)entity);
        velocity = velocity.normalize().times(speed);
        cannon.setSpeed((float)speed);
        cannon.setVelocity(velocity);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)cannon);
        }
    }

    private void applyMovementModifier(EntityLivingBase entity, float multiplier) {
        IAttributeInstance moveSpeed = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        moveSpeed.func_188479_b(MOVEMENT_MODIFIER_ID);
        moveSpeed.func_111121_a(new AttributeModifier(MOVEMENT_MODIFIER_ID, "Water charge modifier", (double)(multiplier - 1.0f), 1));
    }

    public static class WaterCylinderBehaviour
    extends LightCylinderBehaviour {
        @Override
        public Behavior onUpdate(EntityLightCylinder entity) {
            if (entity.getOwner() != null) {
                EntityWaterCannon cannon = AvatarEntity.lookupControlledEntity(entity.field_70170_p, EntityWaterCannon.class, entity.getOwner());
                if (cannon != null) {
                    entity.setCylinderLength(cannon.func_70032_d((Entity)entity.getOwner()));
                    Vec3d height = entity.getOwner().func_174791_d().func_72441_c(0.0, (double)entity.getOwner().func_70047_e() - 0.15, 0.0);
                    Vec3d dist = cannon.func_174791_d().func_178788_d(height).func_72432_b();
                    entity.setPosition(height.func_178787_e(dist.func_186678_a(0.075)));
                    AvatarEntityUtils.setRotationFromPosition((Entity)entity, cannon);
                } else if (entity.field_70173_aa > 1) {
                    entity.func_70106_y();
                }
            } else {
                entity.func_70106_y();
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

