/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.water.tickhandlers;

import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.TickHandler;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class WaterParticleSpawner
extends TickHandler {
    public WaterParticleSpawner(int id) {
        super(id);
    }

    @Override
    public boolean tick(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        World world = ctx.getWorld();
        AbilityData abilityData = AbilityData.get(entity, "water_blast");
        int maxDuration = 40;
        if (abilityData.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
            maxDuration = 60;
        }
        int duration = data.getTickHandlerDuration(this);
        double radius = ((float)maxDuration - (float)duration) / 10.0f;
        if (data.hasTickHandler(TickHandlerController.WATER_CHARGE) && !world.field_72995_K) {
            List bolts;
            WorldServer World2 = (WorldServer)world;
            for (int j = 1; j < 4; ++j) {
                for (int i = 0; i < 90; ++i) {
                    double rScale = radius / 90.0 * (double)i;
                    Vector lookpos = Vector.toRectangular(Math.toRadians(entity.field_70177_z + (float)(j * (i * 4))), 0.0).times(rScale).withY(entity.func_70047_e() / 2.0f);
                    World2.func_175739_a(EnumParticleTypes.WATER_SPLASH, lookpos.x() + entity.field_70165_t, lookpos.y() + entity.func_174813_aQ().field_72338_b, lookpos.z() + entity.field_70161_v, 1, 0.0, 0.0, 0.0, 0.05, new int[0]);
                }
            }
            AxisAlignedBB box = new AxisAlignedBB(entity.field_70165_t + radius, entity.field_70163_u + (double)(entity.func_70047_e() / 2.0f) + radius / 4.0, entity.field_70161_v + radius, entity.field_70165_t - radius, entity.field_70163_u + (double)(entity.func_70047_e() / 2.0f) - radius / 4.0, entity.field_70161_v - radius);
            List projectiles = world.func_72872_a(EntityThrowable.class, box);
            if (!projectiles.isEmpty()) {
                for (Entity e : projectiles) {
                    Vector vel = Vector.getVelocity(e).times(-1.0);
                    e.func_70024_g(vel.x(), 0.0, vel.z());
                }
            }
            if (abilityData.getLevel() >= 2 && !(bolts = world.func_72872_a(Entity.class, box)).isEmpty()) {
                for (Entity e : bolts) {
                    if (e instanceof EntityArrow) {
                        Vector vel = Vector.getVelocity(e).times(-1.0);
                        e.func_70024_g(vel.x(), 0.0, vel.z());
                    }
                    if (!(e instanceof AvatarEntity) || !((AvatarEntity)e).isProjectile()) continue;
                    ((AvatarEntity)e).onMajorWaterContact();
                    ((AvatarEntity)e).setVelocity(((AvatarEntity)e).velocity().times(0.5));
                }
            }
            return false;
        }
        return true;
    }
}

