/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.water.tickhandlers;

import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import com.crowsofwar.avatar.client.particle.NetworkParticleSpawner;
import com.crowsofwar.avatar.client.particle.ParticleSpawner;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.TickHandler;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class WaterSkateHandler
extends TickHandler {
    private final ParticleSpawner particles = new NetworkParticleSpawner();

    public WaterSkateHandler(int id) {
        super(id);
    }

    @Override
    public boolean tick(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        if (!data.hasStatusControl(StatusControlController.SKATING_JUMP)) {
            this.tryStartSkating(data, entity);
        }
        if (data.hasStatusControl(StatusControlController.SKATING_JUMP) && this.skate(data, entity, ctx.getBender())) {
            data.removeStatusControl(StatusControlController.SKATING_JUMP);
            data.getMiscData().setCanUseAbilities(true);
            return true;
        }
        return false;
    }

    private void tryStartSkating(BendingData data, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K && data.hasStatusControl(StatusControlController.SKATING_START) && this.shouldSkate(player, data.getAbilityData("water_skate"))) {
            data.removeStatusControl(StatusControlController.SKATING_START);
            data.addStatusControl(StatusControlController.SKATING_JUMP);
        }
    }

    private boolean skate(BendingData data, EntityLivingBase player, Bender bender) {
        AbilityData abilityData = data.getAbilityData("water_skate");
        double powerRating = bender.calcPowerRating(Waterbending.ID);
        World world = player.field_70170_p;
        int yPos = this.getSurfacePos(player);
        if (!player.field_70170_p.field_72995_K && !this.shouldSkate(player, abilityData)) {
            return true;
        }
        float requiredChi = ConfigStats.STATS_CONFIG.chiWaterSkateSecond / 20.0f;
        if (bender.consumeChi(requiredChi = (float)((double)requiredChi - powerRating / 100.0 * 0.25))) {
            double targetSpeed = abilityData.getLevel() >= 2 ? 1.2 : 0.8;
            targetSpeed += powerRating / 400.0;
            if (player.field_191988_bg != 0.0f) {
                targetSpeed = player.field_191988_bg < 0.0f ? (targetSpeed /= 2.0) : (targetSpeed *= 1.3);
            }
            player.func_70107_b(player.field_70165_t, (double)yPos, player.field_70161_v);
            Vector currentVelocity = new Vector(player.field_70159_w, player.field_70181_x, player.field_70179_y);
            Vector targetVelocity = Vector.toRectangular(Math.toRadians(player.field_70177_z), 0.0).times(targetSpeed);
            double targetWeight = 0.1;
            currentVelocity = currentVelocity.times(1.0 - targetWeight);
            targetVelocity = targetVelocity.times(targetWeight);
            double targetSpeedWeight = 0.2;
            double speed = currentVelocity.magnitude() * (1.0 - targetSpeedWeight) + targetSpeed * targetSpeedWeight;
            Vector newVelocity = currentVelocity.plus(targetVelocity).normalize().times(speed);
            Vector playerMovement = Vector.toRectangular(Math.toRadians(player.field_70177_z - 90.0f), Math.toRadians(player.field_70125_A)).times((double)player.field_70702_br * 0.02);
            newVelocity = newVelocity.plus(playerMovement);
            player.field_70159_w = newVelocity.x();
            player.field_70181_x = 0.0;
            player.field_70179_y = newVelocity.z();
            if (abilityData.isMasterPath(AbilityData.AbilityTreePath.SECOND)) {
                AxisAlignedBB box = new AxisAlignedBB(player.field_70165_t - 1.5, player.field_70163_u, player.field_70161_v - 1.5, player.field_70165_t, player.field_70163_u + 1.5, player.field_70161_v + 1.5);
                List nearby = world.func_72872_a(EntityLivingBase.class, box);
                for (EntityLivingBase target : nearby) {
                    if (target == player) continue;
                    this.pushEntitiesAway(target, player);
                }
            }
            if (player.field_70173_aa % 5 == 0) {
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187806_ee, SoundCategory.PLAYERS, 0.4f, 2.0f);
            }
            this.particles.spawnParticles(world, EnumParticleTypes.WATER_SPLASH, 50, 60, Vector.getEntityPos((Entity)player).plus(0.0, 0.1, 0.0), new Vector(0.2, 0.2, 0.2), true, new int[0]);
            if (player.field_70173_aa % 10 == 0) {
                abilityData.addXp(ConfigSkills.SKILLS_CONFIG.waterSkateOneSecond / 2.0f);
            }
            data.getMiscData().setCanUseAbilities(abilityData.getLevel() >= 1);
        }
        if (player.field_70173_aa % 10 == 0) {
            abilityData.addXp(ConfigSkills.SKILLS_CONFIG.waterSkateOneSecond / 2.0f);
        }
        return false;
    }

    private boolean shouldSkate(EntityLivingBase player, AbilityData data) {
        boolean inWaterBlock;
        IBlockState below = player.field_70170_p.func_180495_p(new BlockPos((Vec3i)player.func_180425_c()).func_177977_b());
        IBlockState playerPos = player.field_70170_p.func_180495_p(new BlockPos((Vec3i)player.func_180425_c()));
        int surface = this.getSurfacePos(player);
        boolean allowWaterfallSkating = data.getLevel() >= 2;
        boolean allowGroundSkating = data.isMasterPath(AbilityData.AbilityTreePath.FIRST);
        boolean onGround = below.func_177230_c() != Blocks.field_150350_a && below.func_177230_c() != Blocks.field_150353_l && below.func_177230_c() != Blocks.field_150356_k;
        boolean onWaterBendableBlock = ConfigStats.STATS_CONFIG.waterBendableBlocks.contains(below.func_177230_c());
        boolean onSnowLayer = playerPos.func_177230_c() == Blocks.field_150431_aC;
        boolean onSlab = !playerPos.func_185913_b() && playerPos.func_177230_c() != Blocks.field_150350_a && playerPos.func_177230_c() != Blocks.field_150353_l && playerPos.func_177230_c() != Blocks.field_150356_k;
        boolean bl = inWaterBlock = below.func_177230_c() == Blocks.field_150355_j && ((Integer)below.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 || allowWaterfallSkating) || player.field_70170_p.func_175727_C(player.func_180425_c()) && (onGround || onSlab) || onWaterBendableBlock || onSnowLayer;
        if (allowGroundSkating && onGround) {
            return !player.func_70093_af() && surface != -1 && (double)surface - player.field_70163_u <= 3.0;
        }
        return !player.func_70093_af() && (player.func_70090_H() || inWaterBlock) && surface != -1 && (double)surface - player.field_70163_u <= 3.0;
    }

    private int getSurfacePos(EntityLivingBase player) {
        World world = player.field_70170_p;
        if (!player.func_70090_H()) {
            return (int)player.field_70163_u;
        }
        Block in = world.func_180495_p(player.func_180425_c()).func_177230_c();
        int increased = 1;
        while (in == Blocks.field_150355_j && increased <= 3) {
            in = world.func_180495_p(player.func_180425_c().func_177981_b(++increased)).func_177230_c();
        }
        return (int)player.field_70163_u + increased;
    }

    private void pushEntitiesAway(EntityLivingBase target, EntityLivingBase entity) {
        Vector velocity = Vector.getEntityPos((Entity)target).minus(Vector.getEntityPos((Entity)entity));
        velocity = velocity.withY(0.1).times(0.1f);
        target.func_70024_g(velocity.x(), velocity.y(), velocity.z());
    }
}

